/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: ortho2d.h,v 1.1 2004/05/15 13:26:24 jd Exp $

   $Log: ortho2d.h,v $
   Revision 1.1  2004/05/15 13:26:24  jd
   first support for gl viewing


 
   Created 05/14/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/graphics/ortho2d.h
  \brief ortho2d projection.
*/

#ifndef LEG_SUPPORT_GRAPHICS_ORTHO_2D
#define LEG_SUPPORT_GRAPHICS_ORTHO_2D

#include "projectiontransformation.h"

namespace leg
{
namespace support
{
namespace graphics
{

class Ortho2D: public ProjectionTransformation
{
   double left;
   double right;
   double bottom;
   double top;

   public:

   Ortho2D (double l, double r, double b, double t);

   void
   Set();
};

}
}
}
#endif
