/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: quadrics.h,v 1.1 2004/04/30 20:15:54 jechk Exp $
   $Log: quadrics.h,v $
   Revision 1.1  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.


   Created 4/25/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file quadrics.h
  \brief Support for GLU's quadrics (for rendering spheres, disks, etc.
*/

#include <GL/glu.h>

#include <leg/support/maths/maths.h>

#ifndef LEG_SUPPORT_GRAPHICS_QUADRICS_H
#define LEG_SUPPORT_GRAPHICS_QUADRICS_H

namespace leg
{
namespace support
{
namespace graphics
{

using namespace maths;

class Quadric
{
public:
  Quadric ();

  ~Quadric ()
  {
    gluDeleteQuadric (quadric);
  }


  GLenum
  GetOrientation ()
  {
    return orientation;
  }

  void
  SetOrientation (GLenum new_orientation)
  {
    orientation = new_orientation;
    gluQuadricOrientation (quadric, orientation);
  }


  GLenum
  GetDrawStyle ()
  {
    return draw_style;
  }

  void
  SetDrawStyle (GLenum new_draw_style)
  {
    draw_style = new_draw_style;
    gluQuadricDrawStyle (quadric, draw_style);
  }


  GLenum
  GetNormals ()
  {
    return normals;
  }

  void
  SetNormals (GLenum new_normals)
  {
    normals = new_normals;
    gluQuadricNormals (quadric, normals);
  }


  bool
  GetTextureCoords ()
  {
    return texture_coords;
  }

  void
  SetTextureCoords (bool new_texture_coords)
  {
    texture_coords = new_texture_coords;
    gluQuadricTexture (quadric, texture_coords? GL_TRUE: GL_FALSE);
  }


  void
  DrawSphere (real radius, int slices, int stacks)
  {
    gluSphere (quadric, radius, slices, stacks);
  }

  void
  DrawCylinder (real base_radius, real top_radius, real height, int slices, int stacks)
  {
    gluCylinder (quadric, base_radius, top_radius, height, slices, stacks);
  }

  void
  DrawDisk (real inner_radius, real outer_radius, int slices, int rings)
  {
    gluDisk (quadric, inner_radius, outer_radius, slices, rings);
  }

  void
  DrawPartialDisk (real inner_radius, real outer_radius, int slices,
		   int rings, real start_angle, real sweep_angle)
  {
    gluPartialDisk (quadric, inner_radius, outer_radius, slices, rings, start_angle, sweep_angle);
  }

private:
  GLUquadric *quadric;

  GLenum orientation, draw_style, normals;
  bool texture_coords;
};

}
}
}

#endif // LEG_SUPPORT_GRAPHICS_QUADRICS_H
