/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: sphere.h,v 1.1 2004/06/21 20:47:29 jechk Exp $
   $Log: sphere.h,v $
   Revision 1.1  2004/06/21 20:47:29  jechk
   Added new files in maths.



   Created 6/19/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file leg/support/maths/sphere.h
  \brief A class representing a sphere.
*/

#ifndef LEG_SUPPORT_MATHS_SPHERE_H
#define LEG_SUPPORT_MATHS_SPHERE_H

#include <leg/support/maths/volume.h>

#include <vector>

namespace leg
{

namespace support
{

namespace maths
{

class Sphere : public Volume
{
public:
  Sphere (const Point<3>& center, real radius);
  virtual ~Sphere ();

  virtual bool HitsPoint (const Point<3>& pt);
  virtual bool HitsLine (Line<3> line, real t);

  Point<3>
  GetCenter ()
  {
    return center;
  }

  real
  GetRadius ()
  {
    return radius;
  }

  bool
  HitsLine (Line<3> line)
  {
  }

  Sphere*
  Clone()
  {
     return new Sphere (*this);
  }

private:
  Point<3> center;
  real radius;
};

}

}

}

#endif // LEG_SUPPORT_MATHS_VOLUME_H
