/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: volume.h,v 1.1 2004/06/21 20:47:29 jechk Exp $
   
   $Log: volume.h,v $
   Revision 1.1  2004/06/21 20:47:29  jechk
   Added new files in maths.

   Created 6/19/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file leg/support/maths/volume.h
  \brief A generic class representing solids (such as spheres and cubes).
*/

#ifndef LEG_SUPPORT_MATHS_VOLUME_H
#define LEG_SUPPORT_MATHS_VOLUME_H

#include <leg/support/maths/line.h>

namespace leg
{

namespace support
{

namespace maths
{

class Volume
{
public:
  Volume ();
  
  virtual ~Volume ();

  virtual bool 
  HitsPoint (const Point<3>& pt) = 0;
  
  virtual bool
  HitsLine (Line<3> line) = 0;

  // Jdf on april 11 2004
  virtual Volume*
  Clone() = 0;
};

}

}

}

#endif // LEG_SUPPORT_MATHS_VOLUME_H
