/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 07/28/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/model/baseformatloader.h
  \brief base class for format loaders.
*/

#ifndef LEG_SUPPORT_MODEL_BASE_FORMAT_LOADER_H
#define LEG_SUPPORT_MODEL_BASE_FORMAT_LOADER_H

#include <string>

namespace leg
{
namespace support
{
namespace model
{

class Model;

class BaseFormatLoader
{
   protected:

   std::string file_name;
   bool	       loaded;
   float       file_rescale;

   BaseFormatLoader();

   // when copying from an already loaded model, this will tells this new object
   // hasn't loaded it yet, so allowing multiple models from one file.
   BaseFormatLoader (const BaseFormatLoader& bfl);

   public:

   virtual ~BaseFormatLoader();

   virtual Model&
   Load (const std::string& filename) = 0;

   virtual void
   Save (const std::string& filename, Model& mdl) = 0;

   virtual BaseFormatLoader&
   Clone() = 0;

   //! it's a shame for the pure virtuality we could have produced here.
   bool
   IsLoaded();

   void
   SetFileRescale (float r);

   protected:

   void
   Copy (const BaseFormatLoader& bfl);
};

}
}
}

#endif
