/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 03/27/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/model/formatleg.h
  \brief all support for leg models.
*/

#ifndef LEG_SUPPORT_MODEL_FORMAT_MD2_H
#define LEG_SUPPORT_MODEL_FORMAT_MD2_H

#include "baseformatloader.h"
#include "modelclass.h"
#include "md2impl.h"

namespace leg
{
namespace support
{
namespace model
{

class Meshes;
class FormatMd2;

class Md2Model: public AnimatedModel
{
   enum State
   {
      idle,
      crouch,
      run,
      jump,
      hit
   };
   
   static float scale;

   CMD2Model  *md2;
   float   percent;
   State     state;
   
   public:
   
   Md2Model();

   void
   Default();

   void
   Update();
   
   std::list<Meshes*>&
   GetMeshes();
   
   private:
   
   friend class FormatMd2;
};

class FormatMd2: public BaseFormatLoader
{
   Md2Model *mdl;
   
   public:
   
   static const std::string extension;
   
   FormatMd2();
   
   FormatMd2 (const FormatMd2& v);
   
   ~FormatMd2();
   
   Md2Model&
   Load (const std::string& f);
   
   void
   Save (const std::string& filename, Model& mdl);
   
   BaseFormatLoader&
   Clone();
   
   protected:
   
   void
   Copy (const FormatMd2& f);
};

}
}
}

#endif
