/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 07/28/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/model/loader.h
  \brief model format loader static class.
*/

#ifndef LEG_SUPPORT_MODEL_LOADER_H
#define LEG_SUPPORT_MODEL_LOADER_H

#include "baseformatloader.h"

namespace leg
{
namespace support
{
namespace model
{

//! 3D model/map loader.
/*!
 * Simple model and map loader that is not protected against multithreading.
 *
 * This class should take profit from Loki's TYPELIST as long as they could be
 * used there. We should do some compile-time manipulation that creates an array
 * of available supported formats, in order them to be used there (We cannot go
 * threw a loki's TypeList during runtime).
 * 
 * status:
 *    experimenting.
 *
 * info:
 *    libs::model will layer this class into a multithreading protected stuff.
 *
 * @sa BaseFormatLoader,Model.
 */
struct Loader
{
   static Model&
   LoadModel (const std::string& filename);

   static Model&
   LoadModel (const std::string& filename, float rescale);

   /*static Map&
   LoadMap (const std::string& filename);*/
};

}
}
}

#endif
