/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 07/28/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/model/modelclass.h
  \brief model class.
*/

#ifndef LEG_SUPPORT_MODEL_MODEL_CLASS_H
#define LEG_SUPPORT_MODEL_MODEL_CLASS_H

#include "entity.h"
#include "meshes.h"
#include <list>

#include <iostream>

namespace leg
{
namespace support
{
namespace model
{

class Model: public Entity
{
   public:

   class Alterator
   {
      public:

      static void
      AddTexture (Model& m, Texture& t)
      {
	 MeshList::const_iterator i = m.BeginMesh();
	 
	 for (; i != m.EndMesh(); ++i)
	    support::model::Meshes::Alterator::AddTexture (*(*i), t);
      }

      static void
      SetMaterial (Model& mesh, Material& mat)
      {
	 std::cout << "Model::Alterator::SetMaterial is not implemented." << std::endl;
	 //mesh.material = mat;
      }

      static void
      SetPos (Model& mdl, support::maths::Vector<3>& p)
      {
	 mdl.pos = p;
      }

      static void
      SetType (Model& mdl, Type t)
      {
	 mdl.type = t;
      }

      static void
      SetMeshType (Model& mdl, MeshType t)
      {
	 mdl.mesh_type = t;
      }

      static void
      AddMesh (Model& mdl, Meshes& m)
      {
	 mdl.mesh_list.push_back (&m);
      }

      static void
      SetVisibilityTest (Model& mdl, VisibilityTest v)
      {
	 mdl.v_test = v;
      }

      static void
      Translate (Model& mdl, const GLdouble *const t)
      {
	 MeshList::const_iterator i = mdl.BeginMesh();
	 
	 for (; i != mdl.EndMesh(); ++i)
	    support::model::Meshes::Alterator::Translate (*(*i), t);
      }

      // plus many other funcs that a modeler can do (add vertices...)
   };

   typedef std::list<Meshes*> MeshList;
   
   protected:
   
   MeshList mesh_list;

   public:

   Model();

   Model (const Model& m);
   
   ~Model();
      
   void
   AddMesh (Meshes& mesh);
   
   // free all the memory allocated for this model (when no more used).
   void
   Free();

   GLuint
   MakeDisplayList();

   inline MeshList::const_iterator
   BeginMesh()
   {
      return mesh_list.begin();
   }

   inline MeshList::const_iterator
   EndMesh()
   {
      return mesh_list.end();
   }
   
   protected:

   void
   Copy (const Model& m);

   friend class Alterator;
};

class DynamicModel: public Model
{
   public:

   virtual void
   Update() = 0;

   virtual std::list<Meshes*>&
   GetMeshes() = 0;
};

class AnimatedModel: public DynamicModel
{
};

class Map: public Entity
{
   protected:

   std::list<Model*> model_list;
};

}
}
}

#endif
