/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: defaultstatereactorpolicy.h,v 1.3 2004/06/09 20:16:24 jd Exp $
   
   
   Created 03/16/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/states/defaultstatereactorpolicy.h
  \brief First support of states.
*/

#ifndef LEG_SUPPORT_STATES_DEFAULT_STATE_REACTOR_POLICY_H
#define LEG_SUPPORT_STATES_DEFAULT_STATE_REACTOR_POLICY_H

#include <iostream>

namespace leg
{
namespace support
{
namespace states
{

//! Example of a state reaction policy.
/*!
 * This should never be used but reimplemented (with another name if wanted) in
 * the matching location. All such policies must implement the same interface:
 * default constructor, React(Host&,State) and SetStateMutex(Sync&).
 *
 * status:
 *    example.
 *
 * info:
 *    must not be used.
 */
template
<
   class Host,
   typename State,
   class Sync
>
class DefaultStateReactorPolicy
{
   Sync *mutex;
   
   public:

   DefaultStateReactorPolicy ()
   {
   }

   ~DefaultStateReactorPolicy()
   {
   }

   void
   React (Host& host, State state)
   {
      std::cout << "Current state in React is: " << state << std::endl;
   }

   void
   SetStateMutex (Sync& state_mutex)
   {
      mutex = &state_mutex;
   }
};

}
}
}
#endif
