/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: error.h,v 1.5 2004/04/30 20:15:54 jechk Exp $

   Created 02/18/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/utils/error.h
  \brief First support of error handlings.
*/

#ifndef LEG_SUPPORT_UTILS_ERROR_H
#define LEG_SUPPORT_UTILS_ERROR_H

#include "issue.h"

namespace leg
{
namespace support
{
namespace utils
{
namespace error
{

//! Support for error handlings.
/*!
 * Support for error handlings.
 *
 * status:
 *    useable.
 *
 * info:
 *    This always throw std::exception().
 *    This class is no more intended to users, who will prefer
 *    use Message<X,Y>(...) instead.
 *
 * TODO:
 *    errno management.
 *
 * @sa Message, Issue, Warning
 */
struct Error: public Issue
{
   private:
      
   Error ();
   
   public:

   //! Default constructor needing the error message text.
   /*!
    * The default constructor that needs the error message text.
    */
   explicit Error (const std::string& msg);
   
   explicit Error (const std::string& msg, const std::string& location);
   
   explicit Error (const std::string& msg, const std::string& location, int strerr_val);
};

}
}
}
}
#endif
