/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: issue.h,v 1.2 2004/04/30 20:15:54 jechk Exp $
   $Log: issue.h,v $
   Revision 1.2  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.

   Revision 1.1.1.1  2004/04/25 23:22:43  jd
   start on zionarea

   Revision 1.1  2004/03/10 20:44:57  jd
   initial revision



   Created 03/10/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/utils/issue.h
  \brief class for error handlings.
*/

#ifndef LEG_SUPPORT_UTILS_ISSUE_H
#define LEG_SUPPORT_UTILS_ISSUE_H

#include <string>

namespace leg
{
namespace support
{

//! Common utilities support.
/*!
 * Common classes and other utilities that could be needed threw all leg.
 * You'll find here error management, logging, state machine and library
 * information for the moment.
 */
namespace utils
{

//! Reserved error namespace
/*!
 * This namespace is reserved, but all documentation is still available, just
 * because user types are typedef on those types.
 */
namespace error
{

//! Base class for issues handlings (as Warning, Error...)
/*!
 * Virtual base class for issues.
 * Inherit from this class in order to make your own version
 * of an issue handling.
 *
 * status:
 *    works.
 *
 * info:
 *    This uses stdout as the output. Override Header(), Message(...),
 *    StdVal() and End() for changing this behavior.
 */
class Issue
{
   protected:
      
   std::string header;	   //!< header of the issue message.

   //! Default constructor, giving the header.
   Issue (const std::string& str_err);

   //! Adding the message.
   Issue (const std::string& str_err, const std::string& msg);

   //! Adding the location of the issue.
   Issue (const std::string& str_err, const std::string& msg, const std::string& location);

   //! Adding the value of a strerror.
   Issue (const std::string& str_err, const std::string& msg, const std::string& location, int strerr_val);

   virtual ~Issue();

   //! Writes out a message.
   virtual void
   Out (const std::string& msg);
  
   //! Writes out a message and its location.
   virtual void
   Out (const std::string& msg, const std::string& location);
   
   //! Writes out a message, its location and its error value.
   virtual void
   Out (const std::string& msg, const std::string& location, int strerror_val);
   
   //! Prints out the header.
   virtual void
   Header();

   //! Prints out the message.
   virtual void
   Message (const std::string& msg);
   
   //! Prints out the message and its location.
   virtual void
   Message (const std::string& msg, const std::string& location);
   
   //! Get the string from a std error.
   virtual void
   StdVal (const int val);

   //! Prints out the end of the message (generally end of line).
   virtual void
   End();
};

}
}
}
}
#endif
