/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: log.h,v 1.1 2004/04/30 20:15:54 jechk Exp $
   $Log: log.h,v $
   Revision 1.1  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.

   Revision 1.1.1.1  2004/04/25 23:22:43  jd
   start on zionarea




   Created 04/02/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/utils/log.h
  \brief log support.
*/

#ifndef LEG_SUPPORT_UTILS_LOG_H
#define LEG_SUPPORT_UTILS_LOG_H

#include <string>
#include <fstream>

namespace leg
{
namespace support
{
namespace utils
{

#ifndef LEG_LOG_FILENAME
#define LEG_LOG_FILENAME "leg.log"
#endif
#ifndef LEG_LOG_DIRNAME
#define LEG_LOG_DIRNAME "./"
#endif
#ifndef LEG_LOG_PREPEND_MSG
#define LEG_LOG_PREPEND_MSG "Leg: "
#endif

//! Default Implementation for logs.
/*!
 * This class is a default implementation for logs into legs.
 *
 * status:
 *    useable.
 *
 * info:
 *    ISO compliancy.
 *    This class is not protected from multithreaded issues, so please
 *    use synchronization tools with it.
 */
class Log
{
   protected:
   
   static std::ofstream file_stream;	    //!< file stream.
   
   private:

   Log ();
   Log (const Log&);
   const Log& operator = (const Log&);

   public:

   Log (const std::string& msg);
   
   ~Log();
   
   //! Open log file.
   static void
   Open();
   
   //! Close log file.
   static void
   Close();
   
   //! Write message to log file.
   /*!
    * Implemented pure virtual function providen as this.
    * You may be satisfied with it, or override it.
    */
   static void
   Write (const std::string& msg);
   
   //! Format the log inputs.
   /*!
    * Implemented pure virtual function provided as this.
    * You may be satisfied with it, or override it.
    */
   static void
   Format();
};

//! No Logs at all.
/*!
 * When no logs are wanted, use NoLog as the second template 
 * argument from Message.
 *
 * @sa Message
 *
 * status:
 *    unknown.
 *
 * info:
 *    none.
 */
struct NoLog
{
   NoLog (const std::string&){}
   NoLog (const std::string&,const std::string&){}
   NoLog (const std::string&,const std::string&,int strerr_val){}
   ~NoLog(){}
   private:
   NoLog ();
};

}
}
}
#endif
