/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: message.h,v 1.2 2004/06/15 07:18:53 jd Exp $

   Created 04/04/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/utils/message.h
  \brief message (errors,logs...) handlings.
*/

#ifndef LEG_SUPPORT_UTILS_MESSAGE_H
#define LEG_SUPPORT_UTILS_MESSAGE_H

#include <string>

namespace leg
{
namespace support
{
namespace utils
{

//! Message output handlings.
/*!
 * User useable Message means.
 * Users should prefer use this way to tell issues as errors, warnings or logs 
 * instead of directly Error, Warning or Log.
 * When calling one of the constructors, and regarding the template arguments 
 * values, this will provoke the matching wanted output(s).
 * 
 * status:
 *    in development.
 *
 * info:
 *    none.
 *    
 * @sa Warning, Error, Log
 */
template
<
   class TError,
   class TLog
>
struct Message
{
   Message<TError,TLog> (const std::string& msg)
   {
      TLog   *log = new TLog (msg);
      TError *data= new TError (msg);
      delete data;
      delete log;      
   };
   
   Message<TError,TLog> (const std::string& msg, const std::string& location)
   {
      TLog   *log= new TLog (location+msg);
      TError *data= new TError (msg,location);
      delete data;
      delete log;
   }
   
   Message<TError,TLog> (const std::string& msg, const std::string& location, int strerr_val)
   {
      TLog   *log = new TLog (location+msg+std::strerror (strerr_val));
      TError *data= new TError (msg,location,strerr_val);
      delete data;
      delete log;
   }
   
   ~Message<TError,TLog>()
   {
   }
};

}
}
}
#endif
