/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: warning.h,v 1.2 2004/04/30 20:15:54 jechk Exp $
   $Log: warning.h,v $
   Revision 1.2  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.

   Revision 1.1.1.1  2004/04/25 23:22:43  jd
   start on zionarea

   Revision 1.1  2004/03/10 20:45:16  jd
   initial revision



   Created 03/10/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/utils/warning.h
  \brief First support of warning handlings.
*/

#ifndef LEG_SUPPORT_UTILS_WARNING_H
#define LEG_SUPPORT_UTILS_WARNING_H

#include "issue.h"

namespace leg
{
namespace support
{
namespace utils
{
namespace error
{

//! Support for warning handlings.
/*!
 * Support for warning handlings.
 *
 * status:
 *    unset.
 *
 * info:
 *    none.
 */
struct Warning: public Issue
{
   Warning ();
   explicit Warning (const std::string& msg);
   explicit Warning (const std::string& msg, const std::string& location);
   explicit Warning (const std::string& msg, const std::string& location, int strerr_val);
};

}
}
}
}
#endif
