/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: glx.h,v 1.1 2004/04/30 01:29:05 jd Exp $

   Created 03/14/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/glx.h
  \brief glx support for windowing.
*/

#ifndef LEG_SUPPORT_WINDOW_GLX_GLX_H
#define LEG_SUPPORT_WINDOW_GLX_GLX_H

#include "glxdrawableimpl.h"
#include "glxwindow.h"
#include "glxdisplay.h"
#include "xattributes.h"
#include "xevent.h"
#include "xkeymap.h"
#include "glxtext.h"

#if GLXVERSION == 12
   #include "glx12drawableimpl.h"
   #include "glx12window.h"

   namespace leg
   {
   namespace support
   {
   namespace window
   {
      //! OSWindow system-dependant window typedef for users.
      /*!
       * OSWindow is the typedef that will be defined for each system, so that
       * it matches the correct working window class. Quick users may only use
       * this type to have a working window.
       * This is the GLX 1.2 support version, and is able to run on system with
       * GLX 1.3 version too.
       *
       * status:
       *    working.
       *
       * info:
       *    none.
       */
      typedef GLX12Window  OSWindow;

      //! Display connection system-dependant typedef for users.
      /*!
       * DisplayConnection is the typedef matching the system-dependant 
       * platform it is running on. It should be defined for each supported
       * system.
       * This is the GLX 1.2 and 1.3 version.
       */
      typedef GLXDisplay   DisplayConnection;
   }
   }
   }
#elif GLXVERSION == 13
   #include "glx13drawableimpl.h"
   #include "glx13window.h"

   namespace leg
   {
   namespace support
   {
   namespace window
   {
      //! OSWindow system-dependant window typedef for users.
      /*!
       * OSWindow is the typedef that will be defined for each system, so that
       * it matches the correct working window class. Quick users may only use
       * this type to have a working window.
       * This is the GLX 1.3 support version only and won't work on earlier
       * versions.
       *
       * status:
       *    working.
       *
       * info:
       *    none.
       */
      typedef GLX13Window  OSWindow;
      
      //! Display connection system-dependant typedef for users.
      /*!
       * DisplayConnection is the typedef matching the system-dependant 
       * platform it is running on. It should be defined for each supported
       * system.
       * This is the GLX 1.2 and 1.3 version.
       */
      typedef GLXDisplay   DisplayConnection;
   }
   }
   }
#else
   #warning "Your system seems to not have any compatible windowing support."
#endif // #if GLXVERSION == 

#endif // LEG_SUPPORT_WINDOW_GLX_GLX_H
