/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: glx13drawableimpl.h,v 1.1 2004/04/30 01:28:16 jd Exp $

   $Log: glx13drawableimpl.h,v $
   Revision 1.1  2004/04/30 01:28:16  jd
   new version of this directory

   Revision 1.2  2004/03/22 03:21:02  jd
   better glx 1.3 support and interface compatibility with glx 1.2

   Revision 1.1  2004/03/15 23:23:25  jd
   glx 1.3 compatibility next release, this file is a copy of the last drawableimpl.h. This is the same for the sources.


 
   Created 02/18/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/glx13drawableimpl.h
  \brief glx 1.3 drawable support
*/

#ifndef LEG_SUPPORT_WINDOW_GLX13DRAWABLEIMPL_H
#define LEG_SUPPORT_WINDOW_GLX13DRAWABLEIMPL_H

#include "glxdrawableimpl.h"

namespace leg
{
namespace support
{
namespace window
{

namespace internal
{

//! rendering drawable impl.
/*!
 * OS-dependant implementation of drawable that matches the glx 1.3 
 * specifications.
 *
 * status: 
 *    working.
 *
 * info: 
 *    The functions tries to be named seemly like for X and glX.
 *    There are some exceptions explained in comments.
 *    Please, refer to glX 1.3 and XFree 4 lib documentation for more details.
 *
 * @sa GLXDrawableImpl
 */
class GLX13DrawableImpl: public GLXDrawableImpl
{
   public:

   internal::FbConfig	*config;	  //!< glx frame buffer config.

   GLX13DrawableImpl();

   private:

   GLX13DrawableImpl (const GLX13DrawableImpl&);

   public:
   
   ~GLX13DrawableImpl();

   //! Creates a context.
   /*!
    * Create a context and allow shared to be a shared
    * context for the contextx memory.
    * Please, refer to glXCreateContextNew() for more details.
    */
   internal::Context
   CreateContext (internal::Context shared);

   //! Destroy the context given in argument.
   void
   DestroyContext (internal::Context c);

   //! Enter the context.
   /*!
    * Enter the context for enabling rendering possibilities.
    * This calls glXMakeContextCurrent().
    */
   inline void
   EnterContext (internal::Context c)
   {
      glXMakeContextCurrent( display, drawable, drawable, c);
   }

   inline void
   LeaveContext (internal::Context c=0)
   {
   }

   //! Return the current context.
   inline internal::Context
   GetCurrentContext ()
   {
      return glXGetCurrentContext();
   }

   //! Create the glx drawable.
   /*!
    * Create the glx drawable that could have rendering
    * commands into it (as gl functions).
    */
   void
   CreateDrawable (int *glx_attr);

   //! Destroys the glx drawable.
   void
   DestroyDrawable ();

   //! Swap the rendering buffers.
   void
   SwapBuffers();

   XVisualInfo* const
   GetVisual (int scr, int *glx_attr);
   
   private:
   
   GLX13DrawableImpl& operator= (const GLX13DrawableImpl&);
};

}// namespace internal
}
}
}
#endif
