/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: glxdisplay.h,v 1.1 2004/04/30 01:28:38 jd Exp $

   Created 03/18/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/glxdisplay.h
  \brief GLX Display and versions support.
*/

#ifndef LEG_SUPPORT_WINDOW_GLXDISPLAY_H
#define LEG_SUPPORT_WINDOW_GLXDISPLAY_H

#include "../displayconnect.h"

namespace leg
{
namespace support
{
namespace window
{

//! GLX Display connection with the X server.
/*!
 * This could open and close connection with your own local X server (as almost 
 * common GNU/Linux distribs. This will permit also to detect glx versions for
 * some compatibility behaviors to adapt.
 *
 * status:
 *    work in progress.
 *
 * info:
 *    Posix standardised (so may not work on other norms).
 *
 * @sa DisplayConnect.
 */
class GLXDisplay: public DisplayConnect
{
   public:

   GLXDisplay();

   ~GLXDisplay();
   
   //! Open a new X Display.
   /*!
    * Actually, the open connection is only compatible with Posix standard. If 
    * your system isn't Posix, this will surely fail. There are actually 
    * nothing planned for such support.
    */
   void
   Open();

   //! Close the display.
   void
   Close();

   using DisplayConnect::Get;

   //! Calculates and returns the glx major and minor versions.
   /*!
    * You must have opened a connection before calling this function.
    */
   void
   GetGLWMVersion (int& rel_maj, int& rel_min);
   
   void 
   CheckThreadSupport();
};

}
}
}
#endif
