/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: glxwindow.h,v 1.5 2004/06/15 12:56:21 jd Exp $

   Created 03/21/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/glxwindow.h
  \brief X glx base class for gl rendering support
*/

#ifndef LEG_SUPPORT_WINDOW_GLXWINDOW_H
#define LEG_SUPPORT_WINDOW_GLXWINDOW_H

#include "../win.h"
#include "../drawable.h"
#include "xattributes.h"
#include "../displayconnect.h"

namespace leg
{
namespace support
{
namespace window
{

//! glx Window base class.
/*!
 * XFree glx base class for windowing.
 * This class is not intended to be used by end-users.
 * Inherit from it if and only if you have a glx not supported version (this 
 * should not happend).
 * For info about all functions, please refer to Window.
 *
 * status:
 *    working.
 *
 * info:
 *    This class should have been named GLXWindow, but this provoked 
 *    ambiguities with glx.
 *    Using no decoration in window and loosing focus will provoke the lost of
 *    the keyboard focus during all the time the window stays at this state.
 *
 * @sa Window, XWindow, GLX12Window
 */
class BaseGLXWindow: public Window
{
   protected:

   typedef XAttributes	AttrType;

   AttrType		attr;		  //!< x attributes.
   XF86VidModeModeInfo	mode_info;	  //!< XFree screen mode info.
   XF86VidModeModeInfo 	**modes;	  //!< Available modes.
   int			scr;		  //!< Xfree screen.
   int			desk_mode;	  //!< Desk mode.
   int			best_mode;	  //!< Best mode (for fullscreen uses only).
   XVisualInfo		*visual_info;	  //!< visual info.
   internal::Context	context;	  //!< Default context for the window.

   //! Only available constructor.
   BaseGLXWindow (DisplayConnect& disp);

   ~BaseGLXWindow();
  
   void
   GetGlxVersion();

   void
   CreateScreen();

   internal::Window
   CreateXWindow();
   
   void 
   SwitchToFullScreen();

   void 
   SwitchToWindow();
};

Cursor
DeleteXCursor (internal::Display *disp, internal::Window *win);


}
}
}
#endif
