/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: xattributes.h,v 1.2 2004/05/09 23:33:55 jd Exp $

   Created 03/08/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/xattributes.h
  \brief X-Free Attributes for gl window rendering support.
*/

#ifndef LEG_SUPPORT_WINDOW_XATTRIBUTES_H
#define LEG_SUPPORT_WINDOW_XATTRIBUTES_H

#include "../attributes.h"
#include <GL/glx.h>
#include <X11/extensions/xf86vmode.h>

namespace leg
{
namespace support
{
namespace window
{

//! XFree window attributes support.
/*!
 * This is the XFree attributes support for windowing.
 *
 * status: 
 *    in development.
 *
 * info: 
 *    none.
 *
 * @sa Attributes
 */
class XAttributes: public Attributes
{
   XSetWindowAttributes	attributes;    //!< the X window attributes.

   int 			*glx_attr;     //!< the glx window attributes. They should be allocated dynamically.

   int			glx_attr_nb;   //!< Number of attributes in the attributes array glx_attr.

   public:

   //! Default and only constructor.
   /*!
    * This sets window width to 800 and height to 600 by default.
    */
   XAttributes (unsigned int w=800, unsigned int h=600);

   ~XAttributes();

   XAttributes (const XAttributes&);
   
   XAttributes&
   operator = (const XAttributes&);

   //! Creates the glx attributes.
   /*! 
    * Creates the glx attributes array.
    * 
    * @sa Attributes.
    */
   void
   CreateGlxAttr (int size);
 
   //! Destroys the glx attributes.
   /*!
    * Destroys the glx attributes, but with saving the current configuration.
    */
   void
   DestroyGlxAttr();
   
   //! Copy the glx attributes from the given pointer.
   /*!
    * This will copy only the 27 first values, so be aware to have exactly the
    * same size, making sure your array last element values is 'None'.
    */
   void
   CopyGlxAttr (int *glxattr);

   //! Creates the glx 1.3 attributes array values.
   /*! 
    * Creates the glx attributes regarding the configuration that the user 
    * decided before by any call to member functions of the based class 
    * (Attributes). You'll have to call to this function after changing the 
    * attributes values.
    * 
    * @sa Attributes.
    */
   void
   SetAttributes();

   //! Creates the glx 1.2 attributes array values.
   /*! 
    * Creates the glx 1.2 attributes regarding the configuration that the user 
    * decided before by any call to member functions of the based class 
    * (Attributes). You'll have to call to this function after changing the 
    * attributes values.
    * 
    * @sa Attributes.
    */
   void
   SetGLX12Attributes();

   //! Get the glx attributes.
   int* const
   GetGLWMAttributes (int &nb);

   //! Get the X attributes.
   inline XSetWindowAttributes*
   GetXAttributes ()
   {
      return &attributes;
   }

   //! Set the keyboard auto repeat mode.
   /*!
    * Warning: this affects all the XFree server, so that changes are kept 
    * after any programs lifetime has ended. So, changes back the values
    * before exiting any program (this is done automatically be glx windows).
    */
   void
   SetKeyboardAutoRepeatMode (internal::Display *disp, bool mode);
};
	
}
}
}

#endif
