/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: xkeymap.h,v 1.1 2004/04/30 01:30:05 jd Exp $

   $Log: xkeymap.h,v $
   Revision 1.1  2004/04/30 01:30:05  jd
   new version of this directory


 
   Created 04/15/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/xkeymap.h
  \brief X keyboard map.
*/

#ifndef LEG_SUPPORT_WINDOW_GLX_XKEYMAP_H
#define LEG_SUPPORT_WINDOW_GLX_XKEYMAP_H

#include <X11/keysym.h>
#include <X11/keysymdef.h>
#include "../firsttypes.h"

namespace leg
{
namespace support
{
namespace window
{
namespace key
{
typedef support::window::Key Key;
   
// first line of the keyboard
static const Key key_escape				 = XK_Escape;
static const Key key_f1					 = XK_F1;
static const Key key_f2					 = XK_F2;
static const Key key_f3					 = XK_F3;
static const Key key_f4					 = XK_F4;
static const Key key_f5					 = XK_F5;
static const Key key_f6					 = XK_F6;
static const Key key_f7					 = XK_F7;
static const Key key_f8					 = XK_F8;
static const Key key_f9					 = XK_F9;
static const Key key_f10				 = XK_F10;
static const Key key_f11				 = XK_F11;
static const Key key_f12				 = XK_F12;
static const Key key_print_screen			 = XK_Sys_Req;
static const Key key_stop_loop				 = XK_Scroll_Lock;
static const Key key_pause				 = XK_Pause;

// second line
static const Key key_square				 = 0x0;			 // 	NONE !!!

static const Key key_one					 = XK_KP_1;		 // 1
static const Key key_com_and				 = 0x0;			 // &	NONE !!!
static const Key key_two					 = XK_KP_2;		 // 2
static const Key key_E_aigu				 = XK_Eacute;		 // 
static const Key key_e_aigu				 = XK_eacute;		 // 
static const Key key_tilde				 = XK_asciitilde;	 // ~ or XK_dead_tilde
static const Key key_three					 = XK_KP_3;		 // 3
static const Key key_double_quote			 = XK_quotedbl;		 // "
static const Key key_dieze				 = XK_ssharp;		 // #
static const Key key_four					 = XK_KP_4;		 // 4
static const Key key_apostrophe				 = XK_apostrophe;	 // '
static const Key key_open_brace				 = XK_braceleft;	 // {
static const Key key_five					 = XK_KP_5;		 // 5
static const Key key_open_par				 = XK_parenleft;	 // (
static const Key key_open_bracket			 = XK_bracketleft;	 // [
static const Key key_six					 = XK_KP_6;		 // 6
static const Key key_minus				 = XK_minus;		 // -
static const Key key_pipe				 = XK_bar;		 // |
static const Key key_seven					 = XK_KP_7;		 // 7
static const Key key_E_grave				 = XK_Egrave;		 // 
static const Key key_e_grave				 = XK_egrave;		 // 
static const Key key_grave				 = XK_grave;		 // seem it's `
static const Key key_eight					 = XK_KP_8;		 // 8
static const Key key_underscore				 = XK_underscore;	 // _
static const Key key_backslash				 = XK_backslash;	 // '\'
static const Key key_nine					 = XK_KP_9;		 // 9
static const Key key_C_cedilla				 = XK_Ccedilla;		 // 
static const Key key_c_cedilla				 = XK_ccedilla;		 // 
static const Key key_circumflex				 = XK_asciicircum;	 // ^
static const Key key_zero					 = XK_KP_0;		 // 0
static const Key key_A_grave				 = XK_Agrave;		 // 
static const Key key_a_grave				 = XK_agrave;		 // 
static const Key key_at					 = XK_at;		 // @
static const Key key_degree				 = XK_degree;		 // 
static const Key key_close_par				 = XK_parenright;	 // )
static const Key key_close_bracket			 = XK_bracketright;	 // ]
static const Key key_plus				 = XK_plus;		 // +
static const Key key_equal				 = XK_equal;		 // =
static const Key key_close_brace			 = XK_braceright;	 // }
static const Key key_backspace				 = 65288;		 // <-
static const Key key_inser				 = 0x0;			 // INSER	NONE !!!
static const Key key_begin				 = XK_Begin;		 // begin
static const Key key_page_up				 = XK_Page_Up;		 // page up
static const Key key_numlock				 = XK_Num_Lock;		 // VERR NUM

// 3rd line
static const Key key_tab				 = 65289;
static const Key key_A					 = XK_A;
static const Key key_a					 = XK_a;
static const Key key_Z					 = XK_Z;
static const Key key_z					 = XK_z;
static const Key key_E					 = XK_E;
static const Key key_e					 = XK_e;
static const Key key_R					 = XK_R;
static const Key key_r					 = XK_r;
static const Key key_T					 = XK_T;
static const Key key_t					 = XK_t;
static const Key key_Y					 = XK_Y;
static const Key key_y					 = XK_y;
static const Key key_U					 = XK_U;
static const Key key_u					 = XK_u;
static const Key key_I					 = XK_I;
static const Key key_i					 = XK_i;
static const Key key_O					 = XK_O;
static const Key key_o					 = XK_o;
static const Key key_P					 = XK_P;
static const Key key_p					 = XK_p;
static const Key key_dead_circumflex			 = XK_dead_circumflex;	 // ()
static const Key key_traima				 = 0x0;			 // ()		NONE !!!
static const Key key_dollar				 = XK_dollar;		 // $
static const Key key_sterling				 = XK_sterling;		 // 
static const Key key_o_crossed				 = XK_currency;		 //  ???
static const Key key_suppr				 = XK_Delete;		 // SUPPR
static const Key key_end				 = XK_End;		 // FIN
static const Key key_page_down				 = XK_Page_Down;	 // page down

// 3rd & 4th line
static const Key key_return				 = 65293;		 // ENTREE

// 4th line
static const Key key_caps_lock				 = XK_Caps_Lock;	 // hope it's not shift lock
static const Key key_Q					 = XK_Q;
static const Key key_q					 = XK_q;
static const Key key_S					 = XK_S;
static const Key key_s					 = XK_s;
static const Key key_D					 = XK_D;
static const Key key_d					 = XK_d;
static const Key key_F					 = XK_F;
static const Key key_f					 = XK_f;
static const Key key_G					 = XK_G;
static const Key key_g					 = XK_g;
static const Key key_H					 = XK_H;
static const Key key_h					 = XK_h;
static const Key key_J					 = XK_J;
static const Key key_j					 = XK_j;
static const Key key_K					 = XK_K;
static const Key key_k					 = XK_k;
static const Key key_L					 = XK_L;
static const Key key_l					 = XK_l;
static const Key key_M					 = XK_M;
static const Key key_m					 = XK_m;
static const Key key_percent				 = XK_percent;		// %
static const Key key_U_grave				 = XK_Ugrave;		// 
static const Key key_u_grave				 = XK_ugrave;		// 
static const Key key_mu					 = XK_mu;			// 
static const Key key_asterisk				 = XK_asterisk;		// *


// 5th line
static const Key key_l_shift				 = XK_Shift_L;
static const Key key_greater				 = XK_greater;		// >
static const Key key_less				 = XK_less;			// <
static const Key key_W					 = XK_W;
static const Key key_w					 = XK_w;
static const Key key_X					 = XK_X;
static const Key key_x					 = XK_x;
static const Key key_C					 = XK_C;
static const Key key_c					 = XK_c;
static const Key key_V					 = XK_V;
static const Key key_v					 = XK_v;
static const Key key_B					 = XK_B;
static const Key key_b					 = XK_b;
static const Key key_N					 = XK_N;
static const Key key_n					 = XK_n;
static const Key key_question				 = XK_question;		 // ?
static const Key key_comma				 = XK_comma;		 // ,
static const Key key_period				 = XK_period;		 // .
static const Key key_semicolon				 = XK_semicolon;	 // ;
static const Key key_slash				 = XK_slash;		 // '/'
static const Key key_dbl_point				 = XK_colon;       	 // :
static const Key key_paragraph				 = XK_paragraph;	 // 
static const Key key_exclam				 = XK_exclam;		 // ! or XK_exclamdown
static const Key key_r_shift				 = XK_Shift_R;		 // right shift
static const Key key_up					 = XK_Up;		 // up arrow

// 6th line (last one)
static const Key key_l_ctrl				 = XK_Control_L;
static const Key key_l_alt				 = XK_Alt_L;
static const Key key_space				 = XK_space;
static const Key key_r_alt				 = XK_Alt_R;
static const Key key_r_ctrl				 = XK_Control_R;
static const Key key_left				 = 65361;
static const Key key_down				 = XK_Down;
static const Key key_right				 = XK_Right;

static const Key key_shift_lock				 = XK_Shift_Lock;

/*#ifndef XK_LATIN1
#ifndef XK_LATIN2
#warning "Seul le clavier franais est reconnu pour le moment"
#endif
#else*/
static const Key key_copyright				 = XK_copyright;	 //  (ALT-GR+Shift+c)
static const Key key_hyphen				 = XK_hyphen;		 // - (???)
static const Key euro				 = 0x0;			 // 		NONE !!!!!!
//#endif

static const Key key_diff_ascii				 = 'a'-key_a;

}
}
}
}

#endif
