/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: xkeymap.h,v 1.1 2004/04/30 01:30:05 jd Exp $

   $Log: xkeymap.h,v $
   Revision 1.1  2004/04/30 01:30:05  jd
   new version of this directory


 
   Created 04/15/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/xkeymap.h
  \brief X keyboard map.
*/

#ifndef LEG_SUPPORT_WINDOW_GLX_XKEYMAP_H
#define LEG_SUPPORT_WINDOW_GLX_XKEYMAP_H

#include <SDL/SDL_keysym.h>
#include "../firsttypes.h"

namespace leg
{
namespace support
{
namespace window
{
namespace key
{
typedef support::window::Key Key;
   
// first line of the keyboard
static const Key key_escape				 = SDLK_ESCAPE;
static const Key key_f1					 = SDLK_F1;
static const Key key_f2					 = SDLK_F2;
static const Key key_f3					 = SDLK_F3;
static const Key key_f4					 = SDLK_F4;
static const Key key_f5					 = SDLK_F5;
static const Key key_f6					 = SDLK_F6;
static const Key key_f7					 = SDLK_F7;
static const Key key_f8					 = SDLK_F8;
static const Key key_f9					 = SDLK_F9;
static const Key key_f10				 = SDLK_F10;
static const Key key_f11				 = SDLK_F11;
static const Key key_f12				 = SDLK_F12;
static const Key key_print_screen			 = SDLK_SYSREQ;
static const Key key_stop_loop				 = SDLK_SCROLLOCK;
static const Key key_pause				 = SDLK_PAUSE;

// second line
static const Key key_square				 = (Key)0;
static const Key key_one				 = SDLK_1;		 // 1
static const Key key_com_and				 = (Key)0x0;			 // &	NONE !!!
static const Key key_two				 = SDLK_2;		 // 2
static const Key key_E_aigu				 = (Key)0X0;		 // 
static const Key key_e_aigu				 = (Key)0X0;		 // 
static const Key key_tilde				 = (Key)0X0;	 // ~ or XK_dead_tilde
static const Key key_three				 = SDLK_3;		 // 3
static const Key key_double_quote			 = (Key)0X0;		 // "
static const Key key_dieze				 = (Key)0X0;		 // #
static const Key key_four				 = SDLK_4;		 // 4
static const Key key_apostrophe				 = (Key)0;	 // '
static const Key key_open_brace				 = (Key)0;	 // {
static const Key key_five				 = SDLK_5;		 // 5
static const Key key_open_par				 = (Key)0;	 // (
static const Key key_open_bracket			 = (Key)0;	 // [
static const Key key_six				 = SDLK_6;		 // 6
static const Key key_minus				 = (Key)0;		 // -
static const Key key_pipe				 = (Key)0;		 // |
static const Key key_seven				 = SDLK_7;		 // 7
static const Key key_E_grave				 = (Key)0;		 // 
static const Key key_e_grave				 = (Key)0;		 // 
static const Key key_grave				 = (Key)0;		 // seem it's `
static const Key key_eight				 = SDLK_8;		 // 8
static const Key key_underscore				 = (Key)0;	 // _
static const Key key_backslash				 = (Key)0;	 // '\'
static const Key key_nine				 = SDLK_9;		 // 9
static const Key key_C_cedilla				 = (Key)0;		 // 
static const Key key_c_cedilla				 = (Key)0;		 // 
static const Key key_circumflex				 = (Key)0;	 // ^
static const Key key_zero				 = SDLK_0;		 // 0
static const Key key_A_grave				 = (Key)0;		 // 
static const Key key_a_grave				 = (Key)0;		 // 
static const Key key_at					 = (Key)0;		 // @
static const Key key_degree				 = (Key)0;		 // 
static const Key key_close_par				 = SDLK_RIGHTPAREN;	 // )
static const Key key_close_bracket			 = (Key)0;	 // ]
static const Key key_plus				 = (Key)0;		 // +
static const Key key_equal				 = SDLK_EQUALS;		 // =
static const Key key_close_brace			 = (Key)0;	 // }
static const Key key_backspace				 = SDLK_BACKSPACE;		 // <-
static const Key key_inser				 = SDLK_INSERT;
static const Key key_begin				 = SDLK_HOME;		 // begin
static const Key key_page_up				 = SDLK_PAGEUP;		 // page up
static const Key key_numlock				 = SDLK_NUMLOCK;

// 3rd line
static const Key key_tab				 = SDLK_TAB;
static const Key key_A					 = (Key)0;
static const Key key_a					 = SDLK_a;
static const Key key_Z					 = (Key)0;
static const Key key_z					 = SDLK_z;
static const Key key_E					 = (Key)0;
static const Key key_e					 = SDLK_e;
static const Key key_R					 = (Key)0;
static const Key key_r					 = SDLK_r;
static const Key key_T					 = (Key)0;
static const Key key_t					 = SDLK_t;
static const Key key_Y					 = (Key)0;
static const Key key_y					 = SDLK_y;
static const Key key_U					 = (Key)0;
static const Key key_u					 = SDLK_u;
static const Key key_I					 = (Key)0;
static const Key key_i					 = SDLK_i;
static const Key key_O					 = (Key)0;
static const Key key_o					 = SDLK_o;
static const Key key_P					 = (Key)0;
static const Key key_p					 = SDLK_p;
static const Key key_dead_circumflex			 = (Key)0;
static const Key key_traima				 = (Key)0x0;
static const Key key_dollar				 = SDLK_DOLLAR;		 // $
static const Key key_sterling				 = (Key)0;		 // 
static const Key key_o_crossed				 = (Key)0;		 //  ???
static const Key key_suppr				 = SDLK_DELETE;		 // SUPPR
static const Key key_end				 = SDLK_END;		 // FIN
static const Key key_page_down				 = SDLK_PAGEDOWN;	 // page down

// 3rd & 4th line
static const Key key_return				 = SDLK_RETURN;		 // ENTREE

// 4th line
static const Key key_caps_lock				 = SDLK_CAPSLOCK;	 // hope it's not shift lock
static const Key key_Q					 = (Key)0;
static const Key key_q					 = SDLK_q;
static const Key key_S					 = (Key)0;
static const Key key_s					 = SDLK_s;
static const Key key_D					 = (Key)0;
static const Key key_d					 = SDLK_d;
static const Key key_F					 = (Key)0;
static const Key key_f					 = SDLK_f;
static const Key key_G					 = (Key)0;
static const Key key_g					 = SDLK_g;
static const Key key_H					 = (Key)0;
static const Key key_h					 = SDLK_h;
static const Key key_J					 = (Key)0;
static const Key key_j					 = SDLK_j;
static const Key key_K					 = (Key)0;
static const Key key_k					 = SDLK_k;
static const Key key_L					 = (Key)0;
static const Key key_l					 = SDLK_l;
static const Key key_M					 = (Key)0;
static const Key key_m					 = SDLK_m;
static const Key key_percent				 = (Key)0;		// %
static const Key key_U_grave				 = (Key)0;		// 
static const Key key_u_grave				 = (Key)0;		// 
static const Key key_mu					 = (Key)0;			// 
static const Key key_asterisk				 = SDLK_ASTERISK;     // *


// 5th line
static const Key key_l_shift				 = SDLK_LSHIFT;
static const Key key_greater				 = SDLK_GREATER;		// >
static const Key key_less				 = SDLK_LESS;			// <
static const Key key_W					 = (Key)0;
static const Key key_w					 = SDLK_w;
static const Key key_X					 = (Key)0;
static const Key key_x					 = SDLK_x;
static const Key key_C					 = (Key)0;
static const Key key_c					 = SDLK_c;
static const Key key_V					 = (Key)0;
static const Key key_v					 = SDLK_v;
static const Key key_B					 = (Key)0;
static const Key key_b					 = SDLK_b;
static const Key key_N					 = (Key)0;
static const Key key_n					 = SDLK_n;
static const Key key_question				 = SDLK_QUESTION;		 // ?
static const Key key_comma				 = SDLK_COMMA;		 // ,
static const Key key_period				 = SDLK_PERIOD;		 // .
static const Key key_semicolon				 = SDLK_SEMICOLON;	 // ;
static const Key key_slash				 = SDLK_SLASH;		 // '/'
static const Key key_dbl_point				 = SDLK_COLON;       	 // :
static const Key key_paragraph				 = (Key)0;	 // 
static const Key key_exclam				 = SDLK_EXCLAIM; // !
static const Key key_r_shift				 = SDLK_RSHIFT;		 // right shift
static const Key key_up					 = SDLK_UP;		 // up arrow

// 6th line (last one)
static const Key key_l_ctrl				 = SDLK_LCTRL;
static const Key key_l_alt				 = SDLK_LALT;
static const Key key_space				 = SDLK_SPACE;
static const Key key_r_alt				 = SDLK_RALT;
static const Key key_r_ctrl				 = SDLK_RCTRL;
static const Key key_left				 = SDLK_LEFT;
static const Key key_down				 = SDLK_DOWN;
static const Key key_right				 = SDLK_RIGHT;

static const Key key_shift_lock				 = (Key)0;

static const Key key_copyright				 = (Key)0;		//  (ALT-GR+Shift+c)
static const Key key_hyphen				 = (Key)0;		// - (???)
static const Key euro					 = SDLK_EURO;	// 
//#endif

//static const Key key_diff_ascii				 = 'a'-SDLK_a;

}
}
}
}

#endif
