/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   $Log: $
 
   Created 03/08/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/win.h
  \brief Pure virtual base class for windowing support.
*/

#ifndef LEG_SUPPORT_WINDOW_SDL_WIN_H
#define LEG_SUPPORT_WINDOW_SDL_WIN_H

#include "firsttypes.h"
#include "sdldrawableimpl.h"
#include "sdlattributes.h"
#include "../win.h"
#include <string>

namespace leg
{
namespace support
{
namespace window
{

class SDLWindow: public Window
{
   protected:
   
   typedef Drawable<internal::SDLDrawableImpl>	DrawableType;

   typedef SDLAttributes			AttrType;
   
   bool		     direct_rendered;

   DrawableType	     *drawable;

   unsigned int	     width;
   
   unsigned int	     height;

   internal::Window  window;

   AttrType	     attr;
   
   SDLWindow (DisplayConnect& disp);

   public:

   ~SDLWindow();

   void 
   Create();

   void 
   Destroy();

   BaseDrawable&
   GetDrawable()
   {
      return *drawable;
   }
   
   Attributes&
   GetAttributes();

   void
   ShowCursor (bool);

   protected:

   void 
   SwitchToFullScreen();

   void 
   SwitchToWindow();
};

}
}
}
#endif
