/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: window.h,v 1.6 2004/06/09 20:35:18 jd Exp $

   Created 02/28/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/window.h
  \brief full windowing support.
*/

#ifndef LEG_SUPPORT_WINDOW_WINDOW_H
#define LEG_SUPPORT_WINDOW_WINDOW_H

#include "drawable.h"
#include "attributes.h"
#include "win.h"
#include "abstractwindow.h"
#include "displayconnect.h"
#include "event.h"

#ifdef LEG_USE_SDL
   #include "sdl/sdl.h"
#else
   #ifdef LEG_USE_GLX
      #include "glx/glx.h"
   #else
      #error "Non SDL or Glx not yet supported !"
   #endif
#endif

#endif
