;; This file is part of GNU Libraries and Engines for Games.
;; 
;; $Id: utils.scm,v 1.2 2004/03/08 22:26:36 jechk Exp $
;; $Log: utils.scm,v $
;; Revision 1.2  2004/03/08 22:26:36  jechk
;; Maths update.  Mainly, added Polynomial class.
;;
;; Revision 1.1  2004/03/03 06:08:51  jechk
;; Added some Scheme utility functions.
;;
;;
;; 
;; Created 3/3/04 by Jeff Binder <bindej@rpi.edu>
;; 
;; Copyright (c) 2004 Free Software Foundation
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public
;; License as published by the Free Software Foundation; either
;; version 2.1 of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
;; General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public
;; License along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA


; Like begin, except that the body is evaluated only once;  every
; other time #f is returned.
(define-macro (once . body)
  `(call-once (lambda () ,@body)))

; Call the thunk only once.  After the first time return #f.
(define call-once
  (let ((trigger #f))
    (lambda (thunk)
     (if trigger
	 #f
	 (begin
	   (set! trigger #t)
	   (thunk))))))

; Convert a real number to an integer.
(define (real->integer real)
  (let ((s (number->string real)))
    (string->number (substring s 0 (string-index s #\.)))))


; Raise an error if condition is false, displaying the message and args.
(define-macro (assert condition msg)
  `(if (not ,condition)
      (error ,msg)))

(define call/cc call-with-current-continuation)
(define pi (* (acos 0) 2))

(define (deg-to-rad x) (* x (/ pi 180)))
(define (rad-to-deg x) (* x (/ 180 pi)))

; Sort of the inverse of fold- it applies a list of functions to a
; variable sequentially, using the return value of the first as
; the argument of the second, and so on. It returns the return
; value of the last function.
(define (apply-list var funcs)
  (if (null? funcs)
      var
      (apply-list ((car funcs) var) (cdr funcs))))

; Binds the elements of a list to local variables.  Formals has the
; same format as arguments to lambda;  the list is used as the
; arguments.
;
; Example:
;
; (decompose '(1 2 3 4) (a b . c) (list a b c))
;  => (1 2 (3 4))
(define-macro (decompose list formals . body)
  `(apply (lambda ,formals ,@body) ,list))
