/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 10/04/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/interactivity/event.cc
  \brief user events.
*/

#include "leg/libs/interactivity/event.h"
#include "leg/libs/interactivity/keyboard.h"
#include "leg/libs/interactivity/mouse.h"
#include "leg/support/utils/errors.h"

namespace leg
{
namespace libs
{
namespace interactivity
{
   Event::Event (support::window::Window& w): Parent (w.GetDisplay(),w.GetAttributes())
   {
      Mouse::SetNewScreenSize (win_width,win_height);
   }
   
   void
   Event::Update()
   {
      Parent::Update();

      while (!event_queue.empty()){
	 support::window::UserEvent& ue = event_queue.front();
	 
	 switch (ue.type){
	    case support::window::UserEvent::key_press:
	       Keyboard::PressKey (ue.event.key);
	       break;
	    case support::window::UserEvent::key_release:
	       Keyboard::UnpressKey (ue.event.key);
	       break;
	    case support::window::UserEvent::button_press:
	       Mouse::PressButton (ue.event.mouse.button);
	       break; 
	    case support::window::UserEvent::button_release:
	       Mouse::UnpressButton (ue.event.mouse.button);
	       break;
	    case support::window::UserEvent::mouse_motion:
	    case support::window::UserEvent::button_motion:
	       if (mouse_origin != gl_mouse_origin)
		  ue.event.mouse.coord.y = win_height - ue.event.mouse.coord.y;
	       Mouse::GetCoord().Set (ue.event.mouse.coord.x,ue.event.mouse.coord.y);
	       break;
	    default:
	       support::utils::Error ("Unknown user-event type.","libs::interactivity::Event::Update");
	 }
	 event_queue.pop();
      }
   }
}
}
}
