/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: mouse.cc,v 1.1 2004/06/19 11:36:07 jd Exp $

   Created 06/15/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*!\file libs/interactivity/mouse.cc
  \brief mouse controler.
*/

#include "leg/libs/interactivity/mouse.h"

namespace leg
{
namespace libs
{
namespace interactivity
{
   MouseClickTimeMap Mouse::pressed_time_map;
   MouseClickMap     Mouse::click_map;
   MouseMap	     Mouse::map;
   MouseMap	     Mouse::release_map;
   MouseMap	     Mouse::last_map;
   MouseCoord*	     Mouse::coord = 0;
   Timing	     Mouse::timing;
   GameTime	     Mouse::click_time = .25;
   MouseButton	     Mouse::current_button = 0;
   
   Mouse::Mouse():Controler ()
   {
   }

   Mouse::~Mouse ()
   {
      delete coord;
      coord = 0;
   }

   void
   Mouse::SetNewScreenSize (unsigned int w, unsigned int h)
   {
      if (coord){
	 coord->~MouseCoord ();
	 new (coord) MouseCoord (w,h);
      }
      else
	 coord = new MouseCoord (w,h);
   }

   void
   Mouse::Update ()
   {
   }

   MouseCoord&
   Mouse::GetCoord()
   {
      return *coord;
   }

   void
   Mouse::GetCurrentCoordinates (unsigned int& x, unsigned int& y)
   {
      x = static_cast<unsigned int> (coord->x);
      y = static_cast<unsigned int> (coord->y);
   }
   
   MouseButton
   Mouse::GetCurrentButton()
   {
      return current_button;
   }
   
   const MouseMap&
   Mouse::GetMap()
   {
      return map;
   }

   bool
   Mouse::IsButtonPressed (MouseButton mb)
   {
      return map[mb];
   }

   bool
   Mouse::IsButtonClicked (MouseButton mb)
   {
      return (click_map[mb] == 1);
   }

   bool
   Mouse::IsButtonDoubleClicked (MouseButton mb)
   {
      return (click_map[mb] == 2);
   }

   void
   Mouse::SetClickTimeDuration (GameTime duration)
   {
      if (duration > 0)
	 click_time = duration;
      else
	 leg::support::utils::Warning ("Click time duration could not be negative, keep last value",
	       "leg::libs::interactivity::Mouse::SetClickTime (GameTime)");
   }

   GameTime
   Mouse::GetClickTimeDuration()
   {
      return click_time;
   }

   void
   Mouse::SetSensibility (float s)
   {
      if (s > 0)
	 coord->SetSensibility (s);
   }

   float
   Mouse::GetSensibility ()
   {
      return coord->GetSensibility();
   }

   void
   Mouse::PressButton (MouseButton mb)
   {
      last_map[mb] = map[mb];
      map[mb] = true;
      current_button = mb;
      UpdateButtonStatus (mb,true);
   }

   void
   Mouse::UnpressButton (MouseButton mb)
   {
      last_map[mb] = map[mb];
      map[mb] = false;
      if (current_button == mb)
	 current_button = 0;
      UpdateButtonStatus (mb,false);
   }

   void
   Mouse::UpdateButtonStatus (MouseButton n, bool press)
   {
      if (press)
	 if (!last_map[n])
	    pressed_time_map[n] = timing.GetCurrentTime();
      else{
	 if (last_map[n]){
	    GameTime gt = timing.GetCurrentTime();
	    if ((gt - pressed_time_map[n]) <= click_time)
		  ++click_map[n];
	    else
	       click_map[n] = 0;
	 }
	 else{
	    pressed_time_map[n] = 0;
	    click_map[n] = 0;
	 }
      }
   }
}
}
}
