/* This file is part of GNU Libraries and Engines for Games.

   $Id: guile.cc,v 1.3 2004/07/09 00:36:08 jechk Exp $
   $Log: guile.cc,v $
   Revision 1.3  2004/07/09 00:36:08  jechk
   Fixed compile errors in Guile bindings.

   Revision 1.2  2004/05/23 05:38:28  jechk
   Added the correct message/guile.cc

   Revision 1.1  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.



   Created 4/28/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/message/guile.cc
  \brief Guile bindings for messages.
*/

#include "leg/libs/message/message.h"
#include "leg/support/loki/SmartPtr.h"

#if GUILE
#include "leg/support/guile/guile.h"
#endif // GUILE

namespace leg
{

namespace libs
{

namespace message
{

using namespace std;
using namespace support::guile;
using namespace Loki;

class GuileReceiver : public Receiver
{
public:
  GuileReceiver (Scheme fcn)
    : Receiver (),
      fcn (fcn)
  {
  }

  GuileReceiver (Scheme fcn, SmartPtr<timing::Timing> timing)
    : Receiver (*timing),
      fcn (fcn)
  {
  }

protected:
  virtual void MessageFunc (const Message& message, void *data = NULL)
  {
    Scheme *scm = static_cast<Scheme *> (data);

    CallVoidFunction3 ("(lambda (a b c) (a b c))", fcn, message, *scm);
    delete scm;
  }

private:
  Scheme fcn;
};

void
SetTiming (SmartPtr<Receiver> receiver, SmartPtr<timing::Timing> new_timing)
{
  receiver->SetTiming (*new_timing);
}

void
ReceiveMessage (SmartPtr<Receiver> receiver, string message, Scheme data)
{
  receiver->ReceiveMessage (message, new Scheme (data));
}

void
ReceiveMessageIn (SmartPtr<Receiver> receiver, timing::game_time delay, string message, Scheme data)
{
  receiver->ReceiveMessageIn (delay, message, new Scheme (data));
}

void
ReceiveMessageAt (SmartPtr<Receiver> receiver, timing::game_time time, string message, Scheme data)
{
  receiver->ReceiveMessageAt (time, message, new Scheme (data));
}

#if GUILE
struct GuileStartup
{
  GuileStartup ()
  {
    internal::StartGuile ();

    AddType<Receiver> ("receiver");
    AddType<GuileReceiver> ("receiver");
    AddTypeParent<GuileReceiver, Receiver> ();

    AddConstructorBinding1<GuileReceiver, Scheme> ("new-receiver");
    AddConstructorBinding2<GuileReceiver, Scheme, SmartPtr<timing::Timing> > ("new-receiver-with-timing");

    AddVoidBinding2<SmartPtr<Receiver>, SmartPtr<timing::Timing>, SetTiming> ("set-receiver-timing!");

    AddVoidBinding3<SmartPtr<Receiver>, string, Scheme, ReceiveMessage> ("receive-message!");
    AddVoidBinding4<SmartPtr<Receiver>, timing::game_time, string,
                                    Scheme, ReceiveMessageIn> ("receive-message-in!");
    AddVoidBinding4<SmartPtr<Receiver>, timing::game_time, string,
                                    Scheme, ReceiveMessageAt> ("receive-message-at!");

    LoadFile (DATADIR "/leg/scheme/message.scm");
  }
} guile_startup;
#endif // GUILE

}

}

}
