/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: $

   Created 07/27/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/message/postoffice.cc
  \brief Post-Office message treater.
*/

#include "leg/libs/message/postoffice.h"

namespace leg
{
namespace libs
{
namespace message
{
   Mutex		   PostOffice::mutex;
   Timing		   PostOffice::timing;
   PostOffice::MailQueue   PostOffice::mail_queue;
   
   PostOffice::PostOffice()
   {
   }

   PostOffice::~PostOffice()
   {
   }

   void
   PostOffice::Actualize()
   {
      MailQueue::iterator i;
      TimedMail *mt;
      mutex.Lock();
      i = mail_queue.begin();
      mutex.Unlock();
      mt = &(*i);

      if (i == mail_queue.end())
	 return;
      if (!mt)
	 return;
      
      while (true){
	 if (mt->second <= timing.GetCurrentTime()){
	    mt->first.first->Deliver (mt->first.second);
	    mutex.Lock();
	    Treater *tmp;
	    tmp = mt->first.first;
	    delete tmp;
	    tmp = 0;
	    mail_queue.remove (*i);
	    i = mail_queue.begin();
	    if (i == mail_queue.end()){
	       mutex.Unlock();
	       break;
	    }
	    mutex.Unlock();
	 }
	 else{
	    mutex.Lock();
	    ++i;
	    if (i == mail_queue.end()){
	       mutex.Unlock();
	       break;
	    }
	    mutex.Unlock();
	 }
	 mt = &(*i);
	 if (!mt)
	    break;
      }
   }
}
}
}
