/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: boundingentity.cc,v 1.1 2004/07/15 23:28:23 jd Exp $

   Created 06/28/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/physics/boundingentity.cc
  \brief A bounding entity for physics.
*/

#include "leg/libs/physics/boundingentity.h"
#include "leg/support/utils/errors.h"

namespace leg
{
namespace libs
{
namespace physics
{
   using leg::support::utils::Warning;
   using leg::support::utils::Error;

   BoundingEntity::BoundingEntity(): coef (.95)
   {
   }

   BoundingEntity::BoundingEntity (const BoundingEntity& e)
   {
      Copy (e);
   }
   
   const BoundingEntity& 
   BoundingEntity::operator = (const BoundingEntity& e)
   {
      Copy (e);
      return *this;
   }

   BoundingEntity::~BoundingEntity()
   {
   }

   void
   BoundingEntity::Copy (const BoundingEntity& e)
   {
      coef = e.coef;
   }

   void
   BoundingEntity::UpdateGravity (Vector& g, real height)
   {
      gravity = &g;
      
      // we should update the gravity center here:
      gravity_center = position;

      real delta = (gravity_center(1) - height);
      
      if (delta > distance_precision)
	 Fall();
      else if (delta > -distance_precision){ // we're surely hitting the ground.
	 forces.R = *gravity;
	 forces.R *= -mass;

	 forces.W = Vector (0,0,0);
	 velocity (1) = -coef * velocity (1);
      }
      else
	 forces.W = forces.R = Vector (0,0,0);
   }
}
}
}

