/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: gravitron.cc,v 1.1 2004/07/15 23:28:23 jd Exp $

   Created 06/28/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file libs/physics/gravitron.cc
  \brief gravitron.
*/

#include "leg/libs/physics/gravitron.h"
#include "leg/support/utils/errors.h"

namespace leg
{
namespace libs
{
namespace physics
{
   using leg::support::utils::Warning;
   using leg::support::utils::Error;

   Gravitron::Gravitron(): SimpleEntity()
   {
      gravity_config = submit_gravity;
      moving_config = no_move;
   }

   Gravitron::Gravitron (const Gravitron& g): SimpleEntity (static_cast<const SimpleEntity&> (g))
   {
      Copy (g);
   }

   Gravitron::~Gravitron()
   {
   }
/*
   Entity&
   Gravitron::Clone()
   {
      return *new Gravitron (*this);
   }
*/
   void
   Gravitron::Copy (const Gravitron& g)
   {
      gravity_vector = g.gravity_vector;
   }

   const Vector&
   Gravitron::GetGravity() const
   {
      return gravity_vector;
   }

   void
   Gravitron::SetGravity (const Vector& g)
   {
      gravity_vector = g;
   }

   // Please override it.
   real
   Gravitron::GetHeightAt (const Vector& pos)
   {
      int i = -(int)pos(2);
      return (real)i;
   }

   void
   Gravitron::Submit (Entity& e)
   {
      graviton_list.push_back (&e);
      e.SetGravityConfig (receive_gravity);
   }

   void
   Gravitron::Update()
   {
      SimpleEntity::Update();
      std::list<Entity*>::iterator i = graviton_list.begin();

      for (;i!=graviton_list.end();++i){
	 real height = GetHeightAt ((*i)->GetPosition());
	 (*i)->UpdateGravity (gravity_vector,height);
      }
   }
}
}
}

