/* This file is part of GNU Libraries and Engines for Games.

   $Id: guile.cc,v 1.3 2004/07/09 00:36:08 jechk Exp $
   $Log: guile.cc,v $
   Revision 1.3  2004/07/09 00:36:08  jechk
   Fixed compile errors in Guile bindings.

   Revision 1.2  2004/05/13 04:16:02  jechk
   Split timing into two parts; moved message to libs.

   Revision 1.1  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.



   Created 4/27/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/scene/guile.cc
  \brief Guile bindings for scenes.
*/

#include "leg/libs/scene/scene.h"

#if GUILE
#include "leg/support/guile/guile.h"
#endif // GUILE

using namespace std;
using namespace leg::support;
using namespace leg::libs::message;

namespace leg
{
namespace libs
{
namespace scene
{

#if GUILE

namespace internal
{
void
SetEntityLoc (SmartPtr<Entity> e, real x, real y, real z)
{
  //e->SetLoc (Point<3> (x, y, z));
}

real
GetEntityX (SmartPtr<Entity> e)
{
  //return e->GetLoc ().x;
  return 0.;
}

real
GetEntityY (SmartPtr<Entity> e)
{
  //return e->GetLoc ().y;
  return 0.;
}

real
GetEntityZ (SmartPtr<Entity> e)
{
  //return e->GetLoc ().z;
  return 0.;
}
}

struct GuileStartup
{
  GuileStartup ()
  {
    guile::internal::StartGuile ();


    guile::AddType<Entity> ("entity");
    guile::AddTypeParent<Entity, Receiver> ();

    guile::AddVoidBinding4<SmartPtr<Entity>, real, real, real, internal::SetEntityLoc> ("set-location!");
    guile::AddBinding1<real, SmartPtr<Entity>, internal::GetEntityX> ("get-x");
    guile::AddBinding1<real, SmartPtr<Entity>, internal::GetEntityY> ("get-y");
    guile::AddBinding1<real, SmartPtr<Entity>, internal::GetEntityZ> ("get-z");


    guile::AddType<Scene> ("scene");
    guile::AddConstructorBinding0<Scene> ("new-scene");

    guile::AddVoidMemberBinding1<Scene, SmartPtr<Entity>, &Scene::AddEntity> ("add-entity!");
    guile::AddMemberBinding0<Scene, std::list<SmartPtr<Entity> >, &Scene::GetAllEntities> ("get-all-entities");

    
    guile::LoadFile (DATADIR "/leg/scheme/scene.scm");
  }
} guile_startup;

#endif // GUILE

}
}
}
