/* This file is part of GNU Libraries and Engines for Games.

   $Id: entity.cc,v 1.5 2004/07/03 20:15:22 jd Exp $

   Created 04/02/05 by J-D Frattini <zionarea@free.fr>
   
   Copyright (c) 2004-2005 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file staticobject.cc
  \brief static object
*/

#include "leg/libs/scene/worldinterface.h"
#include "leg/libs/scene/entity.h"

namespace leg
{
namespace libs
{
namespace scene
{

   WorldInterface::~WorldInterface()
   {
   }

   void
   WorldInterface::UpdateTime()
   {
      static bool first = true;

      if (first){
	 Entity::u_clock = Entity::timer.GetCurrentTime();
	 first = ! first;
	 return;
      }
      
      game_time ct = Entity::timer.GetCurrentTime();
      Entity::u_dt = ct - Entity::u_clock;
      Entity::u_clock = ct;
   }

}
}
}
