/* This file is part of GNU Libraries and Engines for Games.

   $Id: color.cc,v 1.2 2004/05/22 06:54:16 jechk Exp $
   $Log: color.cc,v $
   Revision 1.2  2004/05/22 06:54:16  jechk
   Graphics update, mainly framework stuff.

   Revision 1.1  2004/03/28 21:30:07  jechk
   Added the support/graphics module.



   Created 3/26/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/graphics/color.cc
  \brief Class to represent RGBA colors.
*/

#include <iostream>

#include <GL/gl.h>

#include "leg/support/graphics/color.h"

namespace leg
{
namespace support
{
namespace graphics
{

using maths::real;

void
Color::Set () const
{
  glColor4dv (el);
}

Color
GetGlobalColor ()
{
  real a[4];

  glGetDoublev (GL_CURRENT_COLOR, a);

  Color c (a[0], a[1], a[2], a[3]);
  return c;
}

std::ostream &
operator << (std::ostream &s, Color c)
{
  s << "<r = " << c.r << "; g = " << c.g << "; b = " << c.b << "; a = " << c.a << ">";

  return s;
}

}
}
}
