/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: ortho2d.cc,v 1.1 2004/05/15 13:29:03 jd Exp $

   $Log: ortho2d.cc,v $
   Revision 1.1  2004/05/15 13:29:03  jd
   first support for gl viewing


 
   Created 05/14/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/graphics/ortho2d.cc
  \brief ortho2d projection.
*/

#include "leg/support/graphics/ortho2d.h"
#include <GL/glu.h>

namespace leg
{
namespace support
{
namespace graphics
{

   Ortho2D::Ortho2D (double l, double r, double b, double t):  ProjectionTransformation(),
							       left (l),
							       right (r),
							       bottom (b),
							       top (t)
   {
   }

   void
   Ortho2D::Set()
   {
      gluOrtho2D (left,right,bottom,top);
   }
   
}
}
}
