/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: perspective.cc,v 1.1 2004/05/15 13:29:30 jd Exp $

   $Log: perspective.cc,v $
   Revision 1.1  2004/05/15 13:29:30  jd
   first support for gl viewing


 
   Created 05/14/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/graphics/perspective.cc
  \brief perspective view.
*/

#include "leg/support/graphics/perspective.h"
#include <GL/glu.h>

namespace leg
{
namespace support
{
namespace graphics
{

   Perspective::Perspective (double fovy, double a, double n, double f):VisionFrustum (n,f),
									field_of_view_y (fovy),
									aspect (a)
   {
   }

   void
   Perspective::Set()
   {
      gluPerspective (field_of_view_y, aspect, near, far);
   }

}
}
}
