/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: guile.cc,v 1.7 2004/04/30 20:15:54 jechk Exp $
   $Log: guile.cc,v $
   Revision 1.7  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.

   Revision 1.6  2004/03/11 06:44:52  jechk
   Made the Sq function generic; added some TODO comments.

   Revision 1.5  2004/03/08 22:56:56  jechk
   Removed the unneeded support::guile::initialized variable.

   Revision 1.4  2004/03/04 07:22:36  jechk
   Clean up and fixes in Guile code.

   Revision 1.3  2004/03/03 06:08:51  jechk
   Added some Scheme utility functions.

   Revision 1.2  2004/03/03 03:50:02  jechk
   Changed some names, comments and other things for consistency.

   Revision 1.1  2004/03/03 02:05:22  jechk
   Merged many changes.  See ChangeLog for details.


   Created 12/8/03 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2003, 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file leg/support/guile/guile.cc
  \brief Guile support.
*/

#define LEG_USE_SUPPORT
#define LEG_USE_SUPPORT_GUILE

#include "leg/leg.h"
#include "leg/support/utils/error.h"
#include <iostream>

namespace leg
{

namespace support
{

namespace guile
{

std::map<std::string, long> *internal::smob_type;
std::map<std::string, std::list<std::string> > *internal::smob_children;



static SCM leg_c_objs;

Scheme::Scheme (const SCM &scm)
  : scm_val (scm)
{
  // Add the value to a hash table stored in Guile-land that the
  // garbage-collector can see, so it won't be gc'ed.  Note that is
  // appears in the table once for each Scheme object that contains
  // it.
  sym = scm_gensym (SCM_UNDEFINED);
  scm_hashq_set_x (leg_c_objs, sym, scm_val);
}

Scheme::~Scheme ()
{
  scm_hashq_set_x (leg_c_objs, sym, SCM_BOOL_F);
}



namespace internal
{
void
StartGuile ()
{
  if (!scm_initialized_p)
    {
      smob_type = new std::map<std::string, long> ();
      smob_children = new std::map<std::string, std::list<std::string> > ();

      scm_init_guile ();

      leg_c_objs = scm_c_make_hash_table (127);
      scm_c_define ("%leg_c_objs", leg_c_objs);
    }
}
}

struct GuileStartup
{
  GuileStartup ()
  {
    internal::StartGuile ();

    guile::LoadFile (DATADIR "/leg/scheme/utils.scm");
  }
} guile_startup;

}

}

}
