/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: matrix.cc,v 1.3 2004/04/30 20:15:54 jechk Exp $
   $Log: matrix.cc,v $
   Revision 1.3  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.

   Revision 1.2  2004/03/03 03:50:02  jechk
   Changed some names, comments and other things for consistency.

   Revision 1.1  2004/03/03 02:05:22  jechk
   Merged many changes.  See ChangeLog for details.


   Created 1/22/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file leg/support/maths/matrix.cc
  \brief A class representing transformation matrices.
*/

#include <cstring>

#include "leg/support/maths/matrix.h"
#include "leg/support/maths/quaternion.h"
#include "leg/support/utils/error.h"

namespace leg
{

namespace support
{

namespace maths
{

Matrix<4, 4>
TranslationMatrix (const Vector<3> &v)
{
  return Matrix<4, 4> (1, 0, 0, v.x,
		       0, 1, 0, v.y,
		       0, 0, 1, v.z,
		       0, 0, 0, 1);
}

Matrix<4, 4>
ScalingMatrix (const Vector<3> &v)
{
  return Matrix<4, 4> (v.x, 0, 0, 0,
		       0, v.y, 0, 0,
		       0, 0, v.z, 0,
		       0, 0, 0, 1);
}

Matrix<4, 4>
RotationMatrix (real angle, const Vector<3> &v)
{
  real c = cos (angle);
  real s = sin (angle);
  
  return Matrix<4, 4> (v.x * v.x * (1. - c) + c, v.x * v.y * (1. - c) - v.z * s,
		       v.x * v.z * (1. - c) + v.y * s, 0.,
		       v.y * v.x * (1. - c) + v.z * s, v.y * v.y * (1. - c) + c,
		       v.y * v.z * (1. - c) - v.x * s, 0.,
		       v.z * v.x * (1. - c) - v.y * s, v.z * v.y * (1. - c) + v.x * s,
		       v.z * v.z * (1. - c) + c, 0., 0., 0., 0., 1.);
}

}

}

}
