/* This file is part of GNU Libraries and Engines for Games.

   $Id: sphere.cc,v 1.1 2004/06/21 20:47:29 jechk Exp $
   $Log: sphere.cc,v $
   Revision 1.1  2004/06/21 20:47:29  jechk
   Added new files in maths.



   Created 6/19/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2003, 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/maths/sphere.cc
  \brief A class representing a sphere.
*/

#include "leg/support/maths/sphere.h"
#include <iostream>

using namespace std;

namespace leg
{

namespace support
{

namespace maths
{

Sphere::Sphere (const Point<3>& center, real radius)
  : center (center), radius (radius)
{
}

Sphere::~Sphere ()
{
}


bool
Sphere::HitsPoint (const Point<3>& pt)
{
  return (pt - center).MagnitudeSq () < Sq (radius);
}

bool
Sphere::HitsLine (Line<3> line, real t)
{
  t = 0.;

  line.a -= center;
  line.b -= center;

  if (line.a.MagnitudeSq () < Sq (radius))
    return true;

  real a_1 =
    2. * Sq (line.a.x)
    - 2. * line.a.x * line.b.x + 2. * Sq (line.a.y)
    - 2. * line.a.y * line.b.y + 2. * Sq (line.a.z) - 2. * line.a.z * line.b.z;

  real a_2 =
    Sq (line.a.x)
    - 2. * line.a.x * line.b.x + Sq (line.a.y)
    - 2. * line.a.y * line.b.y + Sq (line.a.z) - 2. * line.a.z * line.b.z;

  real b = Sq (a_1) - 4. * a_2 * (-Sq (radius)
				  + Sq (line.a.x)
				  + Sq (line.a.y) + Sq (line.a.z));
  if (b >= 0)
    b = sqrt (b);
  else
    return false;

  real c = 2. * a_2;
  if (c)
    c = 1. / c;
  else
    return false;

  real t_1 = (a_1 - b) * c;
  real t_2 = (a_1 + b) * c;

  t = Min (t_1, t_2);

  return line.IsValidT (t);
}

}

}

}
