/* This file is part of GNU Libraries and Engines for Games.

   $Id: cond.cc,v 1.3 2004/06/02 03:32:31 jd Exp $
   $Log: cond.cc,v $
   Revision 1.3  2004/06/02 03:32:31  jd
   correction for best support of libs

   Revision 1.2  2004/03/03 03:50:02  jechk
   Changed some names, comments and other things for consistency.

   Revision 1.1  2004/03/03 02:05:22  jechk
   Merged many changes.  See ChangeLog for details.


   Created 01/24/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/threads/thread.cc
  \brief First support of conditions for Leg.
*/

#include "leg/support/threads/cond.h"

namespace leg
{
namespace support
{
namespace threads
{
   Condition::Condition ():  date (0)
   {
      Init ();
   }

   Condition::Condition (const Condition& c)
   {
      Copy (c);
      Init ();
   }
		
   Condition::~Condition ()
   {
   }

   Condition& Condition::operator= (const Condition& c)
   {
      Copy (c);
      Init ();
      return *this;
   }

   void Condition::Init ()
   {
      pthread_condattr_init (&attr);
      pthread_cond_init (&cond, &attr);
   }

   void Condition::Destroy ()
   {
      pthread_cond_destroy (&cond);
      pthread_condattr_destroy (&attr);
   }

   void Condition::Copy (const Condition& c)
   {
      cond= c.cond;
      attr= c.attr;
      date= c.date;
   }
}
}
}
