/* This file is part of GNU Libraries and Engines for Games.

   $Id: mutex.cc,v 1.2 2004/03/03 03:50:02 jechk Exp $
   $Log: mutex.cc,v $
   Revision 1.2  2004/03/03 03:50:02  jechk
   Changed some names, comments and other things for consistency.

   Revision 1.1  2004/03/03 02:05:22  jechk
   Merged many changes.  See ChangeLog for details.


   Created 01/23/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/threads/mutex.cc
  \brief First support of mutex for Leg.
*/

#include "leg/support/threads/mutex.h"

namespace leg
{
namespace support
{
namespace threads
{
   Mutex::Mutex ()
   {
      Init ();
   }

   Mutex::Mutex( const Mutex& mut)
   {
      Copy (mut);
   }
      
   Mutex::~Mutex ()
   {
      Destroy ();
   }

   Mutex& Mutex::operator= (const Mutex& src)
   {
      Copy (src);
      return *this;
   }

   void Mutex::Copy (const Mutex& src)
   {
      mutex= src.mutex;
      mutex_attributes= src.mutex_attributes;
      mutex_type= src.mutex_type;
   }
      
   void Mutex::Init ()
   {
      pthread_mutexattr_init (&mutex_attributes);
      pthread_mutex_init (&mutex, &mutex_attributes);
   }

   void Mutex::Destroy ()
   {
      pthread_mutex_destroy (&mutex);
      pthread_mutexattr_destroy (&mutex_attributes);
   }
}
}
}
