/* This file is part of GNU Libraries and Engines for Games.

   $Id: guile.cc,v 1.4 2004/04/30 20:15:54 jechk Exp $
   $Log: guile.cc,v $
   Revision 1.4  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.

   Revision 1.3  2004/03/04 07:22:36  jechk
   Clean up and fixes in Guile code.

   Revision 1.2  2004/03/03 03:50:02  jechk
   Changed some names, comments and other things for consistency.

   Revision 1.1  2004/03/03 02:05:22  jechk
   Merged many changes.  See ChangeLog for details.


   Created 2/18/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/timing/guile.cc
  \brief Guile bindings for timers.
*/

#include "leg/support/timing/timing.h"

#if GUILE
#include "leg/support/guile/guile.h"
#endif // GUILE

namespace leg
{

namespace support
{

namespace timing
{

#if GUILE
class GuileTimer : public Timer
{
public:
  GuileTimer (Loki::SmartPtr<Timing> timing, guile::Scheme thunk)
    : Timer (*timing),
      thunk (thunk)
  {
  }

  void *Go (void *arg)
  {
    guile::CallVoidFunction1 ("(lambda (a) (a))", thunk);
    return NULL;
  }

  int Set (game_time when)
  {
    return Timer::Set (when);
  }

  int SetRepeating (game_time when, game_time interval)
  {
    return Timer::SetRepeating (when, interval);
  }

private:
  guile::Scheme thunk;
};

struct GuileStartup
{
  GuileStartup ()
  {
    guile::internal::StartGuile ();


    guile::AddType<Timing> ("timing");
    guile::AddConstructorBinding2<Timing, double, game_time> ("new-timing");
   
    guile::AddVoidMemberBinding1<Timing, double, &Timing::SetUnitsPerSec> ("set-units-per-second!");
    guile::AddVoidMemberBinding1<Timing, game_time, &Timing::SetCurrentTime> ("set-current-time!");
    guile::AddMemberBinding0<Timing, game_time, &Timing::GetCurrentTime> ("get-current-time");
    
    
    guile::AddType<Timer> ("nonguile-timer");
    guile::AddType<GuileTimer> ("timer");
    guile::AddTypeParent<GuileTimer, Timer> ();
    guile::AddConstructorBinding2<GuileTimer, Loki::SmartPtr<Timing>, SCM> ("new-timer");
  
    guile::AddMemberBinding1<GuileTimer, int, game_time, &GuileTimer::Set> ("timer-set!");
    guile::AddMemberBinding2<GuileTimer, int, game_time, game_time, &GuileTimer::SetRepeating> ("timer-set-repeating!");
    guile::AddVoidMemberBinding1<Timer, int, &Timer::Unset> ("timer-unset!");


    guile::LoadFile (DATADIR "/leg/scheme/timing.scm");
  }
} guile_startup;
#endif // GUILE

}

}

}
