/* This file is part of GNU Libraries and Engines for Games.

   $Id: error.cc,v 1.5 2004/04/30 20:15:54 jechk Exp $
   $Log: error.cc,v $
   Revision 1.5  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.

   Revision 1.1.1.1  2004/04/25 23:22:47  jd
   start on zionarea

   Revision 1.4  2004/03/10 20:46:23  jd
   new error handlings design

   Revision 1.3  2004/03/03 03:50:02  jechk
   Changed some names, comments and other things for consistency.

   Revision 1.1  2004/03/03 02:05:22  jechk
   Merged many changes.  See ChangeLog for details.


   Created 02/18/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/utils/error.cc
  \brief First support of error handlings.
*/

#include "leg/support/utils/error.h"
#include <iostream>

using namespace std;

namespace leg
{
namespace support
{
namespace utils
{
namespace error
{
   const std::string str_head= "Error: ";

   Error::Error(): Issue(str_head)
   {
   }
   
   Error::Error (const std::string& msg): Issue(str_head, msg)
   {
      throw std::exception();
   }

   Error::Error (const std::string& msg, const std::string& location): Issue(str_head,msg,location)
   {
      throw std::exception();
   }

   Error::Error (const std::string& msg, const std::string& location, int strerr_val): Issue(str_head,msg,location,strerr_val)
   {
      throw std::exception();
   }
}
}
}
}

