/* This file is part of GNU Libraries and Engines for Games.

   $Id: infos.cc,v 1.1 2004/06/15 07:19:30 jd Exp $

   Created 06/09/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/utils/infos.cc
  \brief info handlings.
*/

#include "leg/support/utils/infos.h"
#include <iostream>

using namespace std;

namespace leg
{
namespace support
{
namespace utils
{
namespace error
{
   const std::string str_head= "Info: ";

   Info::Info(): Issue(str_head)
   {
   }
   
   Info::Info (const std::string& msg): Issue(str_head,msg)
   {
   }

   Info::Info (const std::string& msg, const std::string& location): Issue(str_head,msg,location)
   {
   }

   Info::Info (const std::string& msg, const std::string& location, int strerr_val): Issue(str_head,msg,location,strerr_val)
   {
   }
}
}
}
}

