/* This file is part of GNU Libraries and Engines for Games.

   $Id: log.cc,v 1.1 2004/04/30 20:15:54 jechk Exp $
   $Log: log.cc,v $
   Revision 1.1  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.

   Revision 1.1.1.1  2004/04/25 23:22:47  jd
   start on zionarea




   Created 04/02/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/utils/log.cc
  \brief Base class for log handlings.
*/

#include "leg/support/utils/log.h"
#include "leg/support/utils/errors.h"
#include <cstdio>
#include <ctime>

namespace leg
{
namespace support
{
namespace utils
{
   std::ofstream Log::file_stream;

   Log::Log (const std::string& msg)
   {
      if (!file_stream.is_open()){
	 Open();
	 Write (msg);
	 Close();
      }
      else
         Write (msg);
   }

   Log::~Log()
   {
      Close();
   }

   void
   Log::Open()
   {
      std::string file= LEG_LOG_DIRNAME;
      file.append (LEG_LOG_FILENAME);
      file_stream.open (file.c_str(), std::ios_base::app);

      if (!file_stream.is_open()){
	 file_stream.open (file.c_str(), std::ios_base::out);
	 if (!file_stream.is_open())
	    leg::support::utils::Error ("Cannot open log file", "leg::support::utils::Log::Open()");
      }
      file_stream << std::endl;
   }

   void
   Log::Close()
   {
      if (file_stream.is_open())
         file_stream.close();
   }

   void
   Log::Write (const std::string& msg)
   {
      Format();
      file_stream << msg << std::endl;
   }

   void
   Log::Format()
   {
      std::string prepend= LEG_LOG_PREPEND_MSG;
      prepend.append ("At: ");
      time_t t;
      t= time (0);
      prepend.append (ctime (&t));
      prepend.append (". Msg: ");
      file_stream << prepend;
   }
}
}
}

