/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: glx12drawableimpl.cc,v 1.2 2004/05/21 23:21:30 jd Exp $

   $Log: glx12drawableimpl.cc,v $
   Revision 1.2  2004/05/21 23:21:30  jd
   corrections for libs/window

   Revision 1.1  2004/04/30 01:37:20  jd
   first release into glx and first support for interactivity

   Revision 1.2  2004/03/22 03:24:40  jd
   glx 1.2 and 1.3 support. initial revision

   Revision 1.1  2004/03/15 23:25:50  jd
   glx 1.2 compatibility first release


 
   Created 02/18/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx12drawable->cc
  \brief glx 1.2 drawable support
*/

#include "leg/support/window/glx/glx12drawableimpl.h"
#include "leg/support/utils/errors.h"

namespace leg
{
namespace support
{
namespace window
{
namespace internal
{
   using leg::support::utils::Error;
   using leg::support::utils::Warning;
   
   GLX12DrawableImpl::GLX12DrawableImpl():GLXDrawableImpl()
   {
   }

   GLX12DrawableImpl::~GLX12DrawableImpl()
   {
   }

   internal::Context
   GLX12DrawableImpl::CreateContext (internal::Context shared)
   {
      Context tmp= glXCreateContext (display, visual_info, shared, GL_TRUE);
      if (!tmp)
	 Error ("Cannot create glx Context", "leg::support::window::GLX12DrawableImpl::CreateContext (Context shared)");
      return tmp;
   }

   void
   GLX12DrawableImpl::DestroyContext (internal::Context c)
   {
      glXDestroyContext (display,c);
   }

   void
   GLX12DrawableImpl::EnterContext (internal::Context c)
   {
      glXMakeCurrent (display, this->window, c);
   }

   void
   GLX12DrawableImpl::LeaveContext (internal::Context c)
   {
      if (!glXMakeCurrent (display, None, 0))
	 Warning ("Cannot release glx context", "leg::support::window::GLX12DrawableImpl::LeaveContext (Context c)");
   }

   void
   GLX12DrawableImpl::CreateDrawable (int *glx_attr)
   {
   }

   void
   GLX12DrawableImpl::DestroyDrawable ()
   {
   }

   XVisualInfo* const
   GLX12DrawableImpl::GetVisual (int scr, int *glx_attr)
   {
      visual_info = glXChooseVisual (display, scr, glx_attr);
      if (!visual_info)
	 Error ("Couldn't get a visual", "leg::support::window::GLX12DrawableImpl::GetVisual (int,int*)");
      return visual_info;
   }   

   void
   GLX12DrawableImpl::SwapBuffers()
   {
      glXSwapBuffers (display, this->window);
   }
}
}
}
}

