/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: glxdisplay.cc,v 1.1 2004/04/30 01:37:20 jd Exp $

   $Log: glxdisplay.cc,v $
   Revision 1.1  2004/04/30 01:37:20  jd
   first release into glx and first support for interactivity

   Revision 1.1  2004/03/22 03:35:44  jd
   glx display support. initial revision



 
   Created 03/20/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glxdisplay.cc
 * \brief glx display connections and glx versions.
*/

#include "leg/support/window/glx/glxdisplay.h"
#include "leg/support/utils/errors.h"

namespace leg
{
namespace support
{
namespace window
{
   using leg::support::utils::Error;
   
   GLXDisplay::GLXDisplay(): DisplayConnect()
   {
      CheckThreadSupport();
   }
   
   GLXDisplay::~GLXDisplay()
   {
      if (display)
	 Close();
   }

   void
   GLXDisplay::Open()
   {
      if (display)
	 Close ();
      display = XOpenDisplay (0);	 // if not under a Posix system, this will surely provokes an error.
      
      if (!display)
	 Error ("Could not initialize display.","support::window::internal::GLXDrawableImpl::OpenDisplay()");
   }

   void
   GLXDisplay::Close()
   {
      XCloseDisplay (display);	//TODO: check BadGC error (errno?)
      display=0;
   }

   void
   GLXDisplay::GetGLWMVersion (int& rel_maj, int& rel_min)
   {
      glXQueryVersion (display, &rel_maj, &rel_min);

      if (rel_maj==1 && rel_min>1)
	 ;
      else if (rel_maj<=1)
	 Error (  "Your glx version is too old.",
		  "support::window::GLXDisplay:GetGlxVersion (int&,int&)");
      else
	 Error (  "Your glx version is not understandable.",
		  "support::window::GLXDisplay::GetGlxVersion (int&,int&)");
   }
   
   void 
   GLXDisplay::CheckThreadSupport()
   {
      using leg::support::utils::Error;
      using leg::support::utils::Warning;
      
      #ifdef _REENTRANT
	 if ((int)XInitThreads()){
	    #ifndef LEG_WINDOWING_IS_THREADED
	       #define LEG_WINDOWING_IS_THREADED 1
	    #endif
	 }
	 else{
	    #ifdef LEG_WINDOWING_IS_THREADED
	       #undef LEG_WINDOWING_IS_THREADED
	    #endif
	    Error (  "No windowing multithread support found.",
		     "leg::support::window::DisplayConnect::CheckThreadSupport()");
	 }
      #else
	    Warning ("Leg is running in single thread mode.",
		     "leg::support::window::DisplayConnect::CheckThreadSupport()");
      #endif
   }
}
}
}

