/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: glxdrawableimpl.cc,v 1.1 2004/04/30 01:37:20 jd Exp $

   $Log: glxdrawableimpl.cc,v $
   Revision 1.1  2004/04/30 01:37:20  jd
   first release into glx and first support for interactivity

   Revision 1.2  2004/03/22 03:36:54  jd
   glx better support.

   Revision 1.1  2004/03/15 23:26:22  jd
   Base class for glx inter-versioning (1.2 and 1.3) compatibility. First release.

   Revision 1.2  2004/03/12 22:05:45  jd
   New revision

   Revision 1.1  2004/03/07 22:59:27  jd
   initial revision


 
   Created 03/20/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glxdrawableimpl.cc
  \brief glx virtual base class drawable support
*/

#include "leg/support/window/glx/glxdrawableimpl.h"
#include "leg/support/utils/errors.h"

namespace leg
{
namespace support
{
namespace window
{
namespace internal
{
   using leg::support::utils::Warning;
   
   GLXDrawableImpl::GLXDrawableImpl(): display(0),
				       drawable(0),
				       visual_info(0)
   {
   }

   GLXDrawableImpl::GLXDrawableImpl (const GLXDrawableImpl& d):display (d.display),
							       drawable (d.drawable),
							       visual_info (d.visual_info)
   {
   }
   
   GLXDrawableImpl& GLXDrawableImpl::operator = (const GLXDrawableImpl& d)
   {
      display = d.display;
      drawable = d.drawable;
      visual_info = d.visual_info;

      return *this;
   }
   
   GLXDrawableImpl::~GLXDrawableImpl()
   {
   }

   bool
   GLXDrawableImpl::CheckDirectRendering (internal::Display *d, internal::Context c)
   {
      if (!glXIsDirect (d?d:display,c)){//c?c:context)){
            Warning ("Direct rendering is NOT enabled !",
		     "leg::support::window::GLXDrawableImpl::CheckDirectRendering()");
	    return false;
      }
      
      return true;
   }
}
}
}
}

