/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: xattributes.cc,v 1.3 2004/05/09 23:36:18 jd Exp $

   $Log: xattributes.cc,v $
   Revision 1.3  2004/05/09 23:36:18  jd
   directory support for all the project, best windowing support, best interactivity support...

   Revision 1.2  2004/05/01 00:06:53  jd
   initial support for fullscreen

   Revision 1.1  2004/04/30 01:37:20  jd
   first release into glx and first support for interactivity

   Revision 1.5  2004/03/22 03:29:37  jd
   better glx 1.3 support and interface compatibility with glx 1.2

   Revision 1.4  2004/03/15 23:26:41  jd
   glx 1.2 compatibility first release

   Revision 1.3  2004/03/13 00:52:18  jd
   glx FBConfig update

   Revision 1.2  2004/03/13 00:47:06  jd
   glx FBConfig update

   Revision 1.1  2004/03/12 22:06:09  jd
   Initial revision


 
   Created 03/08/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/xattributes.cc
  \X-Free Attributes for gl window rendering support.
*/

#include "leg/support/window/glx/xattributes.h"

namespace leg
{
namespace support
{
namespace window
{
   XAttributes::XAttributes (unsigned int w, unsigned int h):  Attributes (w,h),
							       glx_attr (0),
							       glx_attr_nb (0)
   {
      SetAttributes();
   }

   XAttributes::~XAttributes()
   {
      DestroyGlxAttr();
   }

   XAttributes::XAttributes (const XAttributes& a):Attributes (static_cast<const Attributes&> (a)),
						   attributes (a.attributes)
   {
      CopyGlxAttr (a.glx_attr);
   }
   
   XAttributes&
   XAttributes::operator = (const XAttributes& a)
   {
      Attributes::operator = (static_cast<const Attributes&> (a));
      CopyGlxAttr (a.glx_attr);

      return *this;
   }

   void
   XAttributes::CreateGlxAttr (int size)
   {
      glx_attr= new int[size];
      glx_attr_nb=size;
   }
   
   void
   XAttributes::DestroyGlxAttr()
   {
      if (glx_attr)
	 delete [] glx_attr;
      glx_attr=0;
   }

   void
   XAttributes::CopyGlxAttr (int *glxattr)
   {
      int s=sizeof(glxattr)/sizeof(int);
      DestroyGlxAttr();
      CreateGlxAttr(s);      
      for(int i=0;i<s;++i)
	 glx_attr[i]=glxattr[i];
   }

   void
   XAttributes::SetAttributes()
   {
      DestroyGlxAttr();
      CreateGlxAttr (27);
      
      glx_attr[0] = GLX_DOUBLEBUFFER;
      glx_attr[1] = True;
      
      glx_attr[2] = GLX_BUFFER_SIZE;
      glx_attr[3] = /*color?color:*/GLX_DONT_CARE;
      
      glx_attr[4] = GLX_RENDER_TYPE;
      glx_attr[5] = GLX_RGBA_BIT;

      glx_attr[6] = GLX_RED_SIZE;
      glx_attr[7] = /*red?red:*/GLX_DONT_CARE;
      
      glx_attr[8] = GLX_GREEN_SIZE;
      glx_attr[9] = /*green?green:*/GLX_DONT_CARE;
      
      glx_attr[10]= GLX_BLUE_SIZE;
      glx_attr[11]= /*blue?blue:*/GLX_DONT_CARE;
      
      glx_attr[12]= GLX_ALPHA_SIZE;
      glx_attr[13]= /*alpha?alpha:*/GLX_DONT_CARE;
      
      glx_attr[14]= GLX_DEPTH_SIZE;
      glx_attr[15]= /*depth?depth:*/GLX_DONT_CARE;
      
      glx_attr[16]= GLX_X_RENDERABLE;
      glx_attr[17]= True;
      
      glx_attr[18]= GLX_X_VISUAL_TYPE;
      glx_attr[19]= GLX_DIRECT_COLOR;
      
      glx_attr[20]= GLX_STENCIL_SIZE;
      glx_attr[21]= /*stencil?stencil:*/GLX_DONT_CARE;
      
      glx_attr[22]= GLX_DRAWABLE_TYPE;
      glx_attr[23]= GLX_WINDOW_BIT;//|GLX_PBUFFER_BIT;
      
      glx_attr[24]= GLX_LEVEL;
      glx_attr[25]= 0;
      
      glx_attr[26]= None;
   }

   void
   XAttributes::SetGLX12Attributes()
   {
      DestroyGlxAttr();
      CreateGlxAttr (17);
      
      glx_attr[0]= GLX_RGBA;
      glx_attr[1]= GLX_DOUBLEBUFFER;
      
      glx_attr[2]= GLX_RED_SIZE;
      glx_attr[3]= 1;
      
      glx_attr[4]= GLX_GREEN_SIZE;
      glx_attr[5]= 1;
      
      glx_attr[6]= GLX_BLUE_SIZE;
      glx_attr[7]= 1;

      glx_attr[8] = GLX_ALPHA_SIZE;
      glx_attr[9] = 1;

      glx_attr[10]= GLX_BUFFER_SIZE;
      glx_attr[11]= 1;
      
      glx_attr[12]= GLX_DEPTH_SIZE;
      glx_attr[13]= 1;
      
      glx_attr[14] = GLX_STENCIL_SIZE;
      glx_attr[15] = 1;
      
      glx_attr[16]= None;
   }

   int* const
   XAttributes::GetGLWMAttributes (int& nb)
   {
      nb=glx_attr_nb;
      return glx_attr;
   }

   void
   XAttributes::SetKeyboardAutoRepeatMode (internal::Display *disp, bool mode)
   {
      if (!mode)
	 XAutoRepeatOff (disp);
      else
	 XAutoRepeatOn (disp);
   }
}
}
}

