/* This file is part of GNU Libraries and Engines for Games  -*- c++ -*-

   $Id: xevent.cc,v 1.6 2004/06/19 11:15:44 jd Exp $

   Created 04/15/04 by Jean-Dominique Frattini <zionarea@free.fr>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/glx/xevent.cc
 * \brief glx event handlings.
*/

#include "leg/support/window/glx/xevent.h"
#include "leg/support/utils/errors.h"

using leg::support::utils::Warning;

namespace leg
{
namespace support
{
namespace window
{
   XEvent::XEvent (internal::Display *const d, Attributes& a): BaseEvent(),
							       disp (d)
   {
      a.GetSize (win_width,win_height);
   }

   XEvent::~XEvent()
   {
   }

   void
   XEvent::Update ()
   {
      UserEvent ue;
      unsigned int w = 0, h = 0;
      
      while (XPending (disp) > 0){
	 XNextEvent (disp, &event);

         switch (event.type){
	    case Expose:
	       if (event.xexpose.count!=0){
		  break;
	       }
	       break;
	    
	    case CreateNotify:
	       break;
	    
	    case ConfigureNotify:
//	       attr.GetSize (w,h);
	       if ((event.xconfigure.width != (int)w) || (event.xconfigure.height != (int)h)){
//		  attr.SetSize (event.xconfigure.width, event.xconfigure.height);
//		  Resize();
	       }
	       break;

	    case EnterNotify:
	       break;

	    case LeaveNotify:
	       break;
	       
	    case ClientMessage:
	       if (*XGetAtomName (disp, event.xclient.message_type) == *"WM_PROTOCOLS")
		  ; // we should end here...
	       break;
	    
	    case FocusIn:
	       break;
	    case FocusOut:
	       break;
	    case MapRequest:
	       break;
	    case MapNotify:
	       break;

	    case KeyPress:
	       ue.type = UserEvent::key_press;
	       ue.event.key = XLookupKeysym (const_cast<XKeyEvent*> (&event.xkey), 0);
	       event_queue.push (ue);
	       MakeKeyPress (ue.event.key);
	       break;
	       
	    case KeyRelease:
	       ue.type = UserEvent::key_release;
	       ue.event.key = XLookupKeysym (const_cast<XKeyEvent*> (&event.xkey), 0);
	       event_queue.push (ue);
	       MakeKeyRelease (ue.event.key);
	       break;

	    case ButtonPress:
	       ue.type = UserEvent::button_press;
	       ue.event.mouse.button = event.xbutton.button;
	       event_queue.push (ue);
	       MakeMouseButtonPress (ue.event.mouse.button);
	       break;
	
	    case ButtonRelease:
	       ue.type = UserEvent::button_release;
	       ue.event.mouse.button = event.xbutton.button;
	       event_queue.push (ue);
	       MakeMouseButtonRelease (ue.event.mouse.button);
	       break;

	    case MotionNotify:
	    case ButtonMotionMask:
	       ue.type = UserEvent::mouse_motion;
	       ue.event.mouse.coord.x = event.xmotion.x;
	       ue.event.mouse.coord.y = event.xmotion.y;
	       
	       if (mouse_area_config == partial){
		  if (ue.event.mouse.coord.x < mouse_area.start_x)
		     XWarpPointer (disp, None, None, 0,0,0,0,mouse_area.size_x,0);
		  else if (ue.event.mouse.coord.x > (mouse_area.start_x + mouse_area.size_x))
		     XWarpPointer (disp, None, None, 0,0,0,0,-mouse_area.size_x,0);
		  else if (ue.event.mouse.coord.y < mouse_area.start_y)
		     XWarpPointer (disp, None, None, 0,0,0,0,0,mouse_area.size_y);
		  else if (ue.event.mouse.coord.y > (mouse_area.start_x + mouse_area.size_y))
		     XWarpPointer (disp, None, None, 0,0,0,0,0,-mouse_area.size_y);
	       }
	       
	       event_queue.push (ue);
	       break;
/*
	    case ButtonMotionMask:
	       ue.type = UserEvent::mouse_release;
	       ue.event.mouse.coord.x = event.xmotion.x;
	       ue.event.mouse.coord.y = event.xmotion.y;
	       event_queue.push (ue);
	       break;
*/
	    default:
	       Warning ("Unchecked window event","support::window::XEvent::Update");
	       break;
	 }
      }
   }
   
   void
   XEvent::MakeKeyPress (Key k)
   {
      current_key = k;
      if (save_string_key)
	 current_string_key += k;
   }

   void
   XEvent::MakeKeyRelease (Key k)
   {
      if (current_key == k)
	 current_key = 0;
   }

   void
   XEvent::MakeMouseButtonPress (MouseButton b)
   {
      current_mouse_button = b;
   }

   void
   XEvent::MakeMouseButtonRelease (MouseButton b)
   {
      if (current_mouse_button == b)
	 current_mouse_button = 0;
   }
}
}
}

