/* This file is part of GNU Libraries and Engines for Games.

   $Id: guile.cc,v 1.2 2004/06/20 02:24:03 jechk Exp $
   $Log: guile.cc,v $
   Revision 1.2  2004/06/20 02:24:03  jechk
   Added first support for volumes.

   Revision 1.1  2004/04/30 20:15:54  jechk
   Big merge.  See ChangeLog for details.



   Created 4/26/04 by Jeff Binder <bindej@rpi.edu>
   
   Copyright (c) 2004 Free Software Foundation
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
/*! \file support/window/guile.cc
  \brief Guile bindings for windowing.
*/

#include "leg/support/window/window.h"

#if GUILE
#include "leg/support/guile/guile.h"
#endif // GUILE

using namespace std;
using namespace leg::support::guile;

namespace leg
{
namespace support
{
namespace window
{

#if GUILE

template<class TW>
class GuileWindow: public TW
{
public:

  GuileWindow (DisplayConnect& disp, Scheme fcn)
    : TW (disp), fcn (fcn)
  {
  }

private:

  Scheme fcn;

  void Redraw()
  {
    CallVoidFunction1 ("(lambda (a) (a))", fcn);
  }
};

void
CreateWindow (Scheme fcn)
{
  typedef AbstractWindow<GLX12Window> GLX12Type;
   
  leg::support::window::Window *win=0;
   
  cout << "creating display..." << flush;
  DisplayConnect *dc= new GLXDisplay;
  cout << " done." << endl << "opening display..." << flush;
  dc->Open();
  int glx_maj=0,glx_min=0;
  dc->GetGLWMVersion (glx_maj,glx_min);
  cout << " done." << endl << "constructing window..." << flush;

  win= new GuileWindow<GLX12Type> (*dc, fcn);

  cout << " done." << endl << "creating window..." << endl;
  win->Create();

  cout << " done." << endl;

  leg::support::window::Event events (dc->Get());
  leg::support::window::Event::UEvent *ev = 0;
  
  cout << "Running. (Type Ctrl-C within this console to stop the test)." << endl;
   
  while(1)
    {
      if ((ev = events.DoEvent ()))
	if (ev->type == KeyRelease)
	  break;
    }
}

struct GuileStartup
{
  GuileStartup ()
  {
    support::guile::internal::StartGuile ();

    AddVoidBinding1<Scheme, CreateWindow> ("create-window!");
  }
} guile_startup;

#endif // GUILE

}
}
}
